/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ClientInformationStringValueLookupFunction
implements Function<OIDCClientInformation, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationStringValueLookupFunction.class);
    @Nonnull
    private final String keyName;

    public ClientInformationStringValueLookupFunction(@ParameterName(name="keyName") @Nonnull String name) {
        this.keyName = Constraint.isNotEmpty((String)name, (String)"The key name cannot be empty");
    }

    @Override
    @Nullable
    public String apply(@Nullable OIDCClientInformation information) {
        if (information == null || information.getOIDCMetadata() == null) {
            this.log.trace("No client information/metadata available");
            return null;
        }
        Object value = information.getOIDCMetadata().toJSONObject().get((Object)this.keyName);
        if (value == null) {
            this.log.trace("No value found for the key {}", (Object)this.keyName);
            return null;
        }
        return String.valueOf(value);
    }
}

