/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.keyinfo.ext.impl.provider;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.saml.xmlobject.JwksUri;
import net.shibboleth.oidc.security.credential.BasicJWKReferenceCredential;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKSReferenceProvider
extends AbstractKeyInfoProvider {
    private final Logger log = LoggerFactory.getLogger(JWKSReferenceProvider.class);

    public Collection<Credential> process(@Nonnull KeyInfoCredentialResolver resolver, @Nonnull XMLObject keyInfoChild, @Nullable CriteriaSet criteriaSet, @Nonnull KeyInfoResolutionContext kiContext) throws SecurityException {
        URI uri;
        JwksUri jwksUri = this.getJwksUri(keyInfoChild);
        if (jwksUri == null || StringSupport.trimOrNull((String)jwksUri.getURI()) == null) {
            return null;
        }
        try {
            uri = new URI(jwksUri.getURI());
        }
        catch (URISyntaxException e) {
            this.log.warn("Could not build URI from the given value {}", (Object)jwksUri.getURI(), (Object)e);
            return null;
        }
        LazySet credentials = new LazySet();
        credentials.add((Object)new BasicJWKReferenceCredential(uri));
        return credentials;
    }

    public boolean handles(@Nonnull XMLObject keyInfoChild) {
        return this.getJwksUri(keyInfoChild) != null;
    }

    @Nullable
    protected JwksUri getJwksUri(@Nonnull XMLObject xmlObject) {
        if (xmlObject instanceof JwksUri) {
            return (JwksUri)xmlObject;
        }
        return null;
    }
}

