/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.oidc.metadata.RefreshableProviderMetadataResolver;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractFileOIDCEntityResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

public class FilesystemProviderMetadataResolver
extends AbstractFileOIDCEntityResolver<Issuer, OIDCProviderMetadata>
implements RefreshableProviderMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilesystemProviderMetadataResolver.class);

    public FilesystemProviderMetadataResolver(@Nonnull Resource metadata) throws IOException {
        super(metadata);
    }

    public FilesystemProviderMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer, metadata);
    }

    @Nonnull
    public Iterable<OIDCProviderMetadata> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        IssuerIDCriterion issuerIdCriterion;
        this.ifNotInitializedThrowUninitializedComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        IssuerIDCriterion issuerIDCriterion = issuerIdCriterion = criteria != null ? (IssuerIDCriterion)criteria.get(IssuerIDCriterion.class) : null;
        if (issuerIdCriterion == null) {
            this.log.trace("No issuer ID criteria found, returning all");
            return new ArrayList<OIDCProviderMetadata>(this.getBackingStore().getOrderedInformation());
        }
        return new ArrayList<OIDCProviderMetadata>(this.lookupIdentifier(issuerIdCriterion.getIssuerID()));
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCProviderMetadata> iterator;
        Iterable<OIDCProviderMetadata> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.log.warn("Could not find any provider metadata with the given criteria");
        return null;
    }

    @Override
    @Nonnull
    protected List<OIDCProviderMetadata> parse(@Nonnull byte[] bytes) throws ParseException {
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((JSONObject)JSONObjectUtils.parse((String)new String(bytes)));
        assert (metadata != null);
        return CollectionSupport.singletonList((Object)metadata);
    }

    @Override
    @Nonnull
    protected Issuer getKey(@Nonnull OIDCProviderMetadata value) {
        Issuer iss = value.getIssuer();
        assert (iss != null);
        return iss;
    }
}

