/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.oidc.metadata.RefreshableClientInformationResolver;
import net.shibboleth.oidc.metadata.criterion.ClientIDCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractFileOIDCEntityResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FilesystemClientInformationResolver
extends AbstractFileOIDCEntityResolver<ClientID, OIDCClientInformation>
implements RefreshableClientInformationResolver {
    private final Logger log = LoggerFactory.getLogger(FilesystemClientInformationResolver.class);

    public FilesystemClientInformationResolver(@Nonnull Resource metadata) throws IOException {
        super(metadata);
    }

    public FilesystemClientInformationResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer, metadata);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
    }

    @Nonnull
    public Iterable<OIDCClientInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ClientIDCriterion clientIdCriterion;
        this.checkComponentActive();
        ClientIDCriterion clientIDCriterion = clientIdCriterion = criteria != null ? (ClientIDCriterion)criteria.get(ClientIDCriterion.class) : null;
        if (clientIdCriterion == null || clientIdCriterion.getClientID() == null) {
            this.log.trace("No client ID criteria found, returning all");
            return this.updateKeys(this.getBackingStore().getOrderedInformation());
        }
        return this.updateKeys(this.lookupIdentifier(clientIdCriterion.getClientID()));
    }

    @Nonnull
    protected List<OIDCClientInformation> updateKeys(@Nonnull List<OIDCClientInformation> clientInformations) {
        ArrayList<OIDCClientInformation> result = new ArrayList<OIDCClientInformation>();
        for (OIDCClientInformation clientInformation : clientInformations) {
            result.add(clientInformation);
        }
        return result;
    }

    @Nullable
    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCClientInformation> iterator;
        Iterable<OIDCClientInformation> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.log.warn("Could not find any clients with the given criteria");
        return null;
    }

    @Override
    @Nonnull
    protected List<OIDCClientInformation> parse(@Nonnull byte[] bytes) throws ParseException {
        String rawString = new String(bytes);
        try {
            OIDCClientInformation single = OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)rawString));
            assert (single != null);
            this.log.debug("Found single client information from the file");
            return CollectionSupport.singletonList((Object)single);
        }
        catch (ParseException e) {
            this.log.debug("Could not parse single client information from the file, checking for array");
            try {
                JSONArray parsedArray = JSONArrayUtils.parse((String)rawString);
                ArrayList<OIDCClientInformation> result = new ArrayList<OIDCClientInformation>();
                for (Object object : parsedArray) {
                    OIDCClientInformation client = OIDCClientInformation.parse((JSONObject)((JSONObject)object));
                    result.add(client);
                }
                return result;
            }
            catch (ParseException e2) {
                throw new ParseException("Could not parse a single or an array of OIDC client information object(s).", (Throwable)e2);
            }
        }
    }

    @Override
    @Nonnull
    protected ClientID getKey(@Nonnull OIDCClientInformation value) {
        ClientID id = value.getID();
        assert (id != null);
        return id;
    }
}

