/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.oidc.metadata.RefreshableClientInformationResolver;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.slf4j.Logger;

public class ChainingClientInformationResolver
extends AbstractIdentifiableInitializableComponent
implements RefreshableClientInformationResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingClientInformationResolver.class);
    @Nonnull
    @NonnullElements
    private List<ClientInformationResolver> resolvers = CollectionSupport.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<ClientInformationResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nullable @NonnullElements List<? extends ClientInformationResolver> newResolvers) throws ResolverException {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.resolvers = newResolvers == null || newResolvers.isEmpty() ? CollectionSupport.emptyList() : CollectionSupport.copyToList(newResolvers);
    }

    @Nullable
    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCClientInformation> iterator;
        this.ifNotInitializedThrowUninitializedComponentException();
        Iterable<OIDCClientInformation> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<OIDCClientInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.ifNotInitializedThrowUninitializedComponentException();
        for (ClientInformationResolver resolver : this.resolvers) {
            try {
                Iterable clientInformations = resolver.resolve((Object)criteria);
                if (clientInformations == null || !clientInformations.iterator().hasNext()) continue;
                return clientInformations;
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving client information from resolver of type {}, proceeding to next resolver", (Object)resolver.getClass().getName(), (Object)e);
            }
        }
        return CollectionSupport.emptyList();
    }

    public void refresh() throws ResolverException {
        for (ClientInformationResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableClientInformationResolver)) continue;
            ((RefreshableClientInformationResolver)resolver).refresh();
        }
    }

    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (ClientInformationResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableClientInformationResolver)) continue;
            Instant lastUpdate = ((RefreshableClientInformationResolver)resolver).getLastUpdate();
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (ClientInformationResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableClientInformationResolver)) continue;
            Instant lastRefresh = ((RefreshableClientInformationResolver)resolver).getLastRefresh();
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ArrayList<CallSite> resolverDetails = new ArrayList<CallSite>();
        for (ClientInformationResolver resolver : this.resolvers) {
            resolverDetails.add((CallSite)((Object)(resolver.getId() + ": " + this.countClients(resolver) + " clients")));
        }
        this.log.info("ChainingClientInformationResolver was configured with the following resolvers: {}", resolverDetails);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.resolvers = CollectionSupport.emptyList();
    }

    protected int countClients(ClientInformationResolver resolver) {
        Iterable iterable;
        int count = 0;
        try {
            iterable = resolver.resolve((Object)new CriteriaSet());
        }
        catch (ResolverException e) {
            this.log.warn("ChainingClientInformationResolver could not count clients for {}", (Object)resolver.getId());
            return 0;
        }
        if (iterable != null) {
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        return count;
    }
}

