/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.base.Strings;
import com.nimbusds.oauth2.sdk.id.Identifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.slf4j.Logger;

public abstract class AbstractOIDCEntityResolver<Key extends Identifier, Value>
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCEntityResolver.class);
    @NonnullAfterInit
    private JsonBackingStore jsonBackingStore;
    private String logPrefix;
    private boolean failFastInitialization = true;

    protected AbstractOIDCEntityResolver() {
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = String.format("Metadata Resolver %s %s:", ((Object)((Object)this)).getClass().getSimpleName(), this.getId());
        }
        assert (this.logPrefix != null);
        return this.logPrefix;
    }

    public boolean isFailFastInitialization() {
        return this.failFastInitialization;
    }

    public void setFailFastInitialization(boolean failFast) {
        this.checkSetterPreconditions();
        this.failFastInitialization = failFast;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.initOIDCResolver();
        }
        catch (ComponentInitializationException e) {
            if (this.failFastInitialization) {
                this.log.error("OIDC metadata provider failed to properly initialize, fail-fast=true, halting", (Throwable)e);
                throw e;
            }
            this.log.error("OIDC metadata provider failed to properly initialize, fail-fast=false, continuing on in a degraded state", (Throwable)e);
        }
    }

    protected void initOIDCResolver() throws ComponentInitializationException {
        this.jsonBackingStore = this.createNewBackingStore();
    }

    @Nonnull
    @NonnullElements
    protected List<Value> lookupIdentifier(@Nonnull @NotEmpty Key identifier) throws ResolverException {
        if (!this.isInitialized()) {
            throw new ResolverException("Metadata resolver has not been initialized");
        }
        if (identifier == null || Strings.isNullOrEmpty((String)identifier.getValue())) {
            this.log.debug("Identifier was null or empty, skipping search for it");
            return CollectionSupport.emptyList();
        }
        List<Value> allInformation = this.lookupIndexedIdentifier(identifier);
        if (allInformation.isEmpty()) {
            this.log.debug("Backing store does not contain any information with the ID: {}", identifier);
            return allInformation;
        }
        return allInformation;
    }

    @Nonnull
    @NonnullElements
    protected List<Value> lookupIndexedIdentifier(@Nonnull @NotEmpty Key identifier) {
        List allInformation = this.getBackingStore().getIndexedInformation().get(identifier);
        if (allInformation != null) {
            return new ArrayList(allInformation);
        }
        return CollectionSupport.emptyList();
    }

    protected void preProcessEntityDescriptor(@Nonnull Value entityDescriptor, @Nonnull Key key, @Nonnull JsonBackingStore backingStore) {
        backingStore.getOrderedInformation().add(entityDescriptor);
        this.indexEntityDescriptor(entityDescriptor, key, backingStore);
    }

    protected void removeByIdentifier(@Nonnull Key identifier, @Nonnull JsonBackingStore backingStore) {
        Map indexedDescriptors = backingStore.getIndexedInformation();
        List descriptors = indexedDescriptors.get(identifier);
        if (descriptors != null) {
            backingStore.getOrderedInformation().removeAll(descriptors);
        }
        indexedDescriptors.remove(identifier);
    }

    protected void indexEntityDescriptor(@Nonnull Value entityDescriptor, @Nonnull Key key, @Nonnull JsonBackingStore backingStore) {
        List entities = backingStore.getIndexedInformation().get(key);
        if (entities == null) {
            entities = new ArrayList();
            backingStore.getIndexedInformation().put(key, entities);
        } else if (!entities.isEmpty()) {
            this.log.warn("Detected duplicate object for key: {}", key);
        }
        entities.add(entityDescriptor);
    }

    @Nonnull
    protected JsonBackingStore createNewBackingStore() {
        return new JsonBackingStore();
    }

    @NonnullAfterInit
    protected JsonBackingStore getBackingStore() {
        return this.jsonBackingStore;
    }

    protected void setBackingStore(@Nonnull JsonBackingStore newBackingStore) {
        this.jsonBackingStore = (JsonBackingStore)Constraint.isNotNull((Object)newBackingStore, (String)"JsonBackingStore may not be null");
    }

    protected class JsonBackingStore {
        @Nonnull
        private final Map<Key, List<Value>> indexedEntities = new ConcurrentHashMap();
        @Nonnull
        private final List<Value> orderedEntitiess = new ArrayList();

        protected JsonBackingStore() {
        }

        @Nonnull
        public Map<Key, List<Value>> getIndexedInformation() {
            return this.indexedEntities;
        }

        @Nonnull
        public List<Value> getOrderedInformation() {
            return this.orderedEntitiess;
        }
    }
}

