/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.DefaultFileLoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.DefaultResourceLoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilder;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.MetadataPolicyResolver;
import net.shibboleth.oidc.metadata.policy.impl.OIDCMetadataPolicyResolver;
import net.shibboleth.oidc.profile.config.navigate.ResolverBasedRegistrationMetadataPolicyLookupFunction;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.spring.resource.ConditionalResource;
import net.shibboleth.shared.spring.resource.PreferFileSystemResourceLoader;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@ThreadSafe
public class MetadataPolicyLookupStrategyFactory {
    @Nonnull
    public Function<ProfileRequestContext, Map<String, MetadataPolicy>> buildFileLoadingMetadataPolicyResolver(@ParameterName(name="resource") @Nullable String resource, @ParameterName(name="cacheSpec") @Nonnull BatchMetadataCacheBuilderSpec<String, Map<String, MetadataPolicy>> cacheSpec, @ParameterName(name="criteriaSetLookupStrategy") @Nullable Function<ProfileRequestContext, CriteriaSet> criteriaSetLookupStrategy, @ParameterName(name="id") @Nonnull String id) throws ComponentInitializationException, IOException {
        return this.buildFileLoadingMetadataPolicyResolver(resource, cacheSpec, criteriaSetLookupStrategy, id, null);
    }

    @Nonnull
    public Function<ProfileRequestContext, Map<String, MetadataPolicy>> buildFileLoadingMetadataPolicyResolver(@ParameterName(name="resource") @Nullable String resource, @ParameterName(name="cacheSpec") @Nonnull BatchMetadataCacheBuilderSpec<String, Map<String, MetadataPolicy>> cacheSpec, @ParameterName(name="criteriaSetLookupStrategy") @Nullable Function<ProfileRequestContext, CriteriaSet> criteriaSetLookupStrategy, @ParameterName(name="id") @Nonnull String id, @ParameterName(name="defaultContents") @Nullable String defaultContents) throws ComponentInitializationException, IOException {
        Object loadingStrategy;
        Resource fileResource = null;
        if (resource != null && !resource.isEmpty()) {
            PreferFileSystemResourceLoader resourceLoader = new PreferFileSystemResourceLoader();
            fileResource = resourceLoader.getResource(resource);
            loadingStrategy = new DefaultFileLoadingStrategy(fileResource);
        } else if (defaultContents == null) {
            loadingStrategy = new DefaultFileLoadingStrategy(fileResource);
        } else {
            byte[] contents = defaultContents.getBytes("UTF-8");
            assert (contents != null);
            ByteArrayResource staticResource = new ByteArrayResource(contents);
            ConditionalResource conditionalResource = new ConditionalResource((Resource)staticResource);
            conditionalResource.setDefaultContent(defaultContents);
            conditionalResource.setId("Static conditional resource");
            conditionalResource.initialize();
            loadingStrategy = new DefaultResourceLoadingStrategy((Resource)conditionalResource);
        }
        return this.buildMetadataPolicyResolver((LoadingStrategy)loadingStrategy, cacheSpec, criteriaSetLookupStrategy, id);
    }

    @Nonnull
    public Function<ProfileRequestContext, Map<String, MetadataPolicy>> buildResourceLoadingMetadataPolicyResolver(@ParameterName(name="resource") @Nullable Resource resource, @ParameterName(name="cacheSpec") @Nonnull BatchMetadataCacheBuilderSpec<String, Map<String, MetadataPolicy>> cacheSpec, @ParameterName(name="criteriaSetLookupStrategy") @Nullable Function<ProfileRequestContext, CriteriaSet> criteriaSetLookupStrategy, @ParameterName(name="id") @Nonnull String id) throws ComponentInitializationException, IOException {
        DefaultResourceLoadingStrategy resourceStrategy = new DefaultResourceLoadingStrategy(resource);
        return this.buildMetadataPolicyResolver(resourceStrategy, cacheSpec, criteriaSetLookupStrategy, id);
    }

    @Nonnull
    protected Function<ProfileRequestContext, Map<String, MetadataPolicy>> buildMetadataPolicyResolver(@Nonnull LoadingStrategy loadingStrategy, @Nonnull BatchMetadataCacheBuilderSpec<String, Map<String, MetadataPolicy>> cacheSpec, @Nullable Function<ProfileRequestContext, CriteriaSet> criteriaSetLookupStrategy, @Nonnull String id) throws ComponentInitializationException, IOException {
        MetadataCacheBuilder.Builder<String, Map<String, MetadataPolicy>> builder = new MetadataCacheBuilder.Builder<String, Map<String, MetadataPolicy>>();
        cacheSpec.setLoadingStrategy(loadingStrategy);
        cacheSpec.setCacheId(id + "-cache");
        MetadataCache<Map<String, MetadataPolicy>> cache = builder.build(cacheSpec);
        OIDCMetadataPolicyResolver resolver = new OIDCMetadataPolicyResolver(cache);
        resolver.setId(id + "-resolver");
        resolver.initialize();
        ResolverBasedRegistrationMetadataPolicyLookupFunction function = new ResolverBasedRegistrationMetadataPolicyLookupFunction();
        function.setMetadataPolicyResolver((MetadataPolicyResolver)resolver);
        function.setCriteriaSetLookupStrategy(criteriaSetLookupStrategy);
        return function;
    }
}

