/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultOIDCProviderMetadataParsingStrategy
implements Function<byte[], List<OIDCProviderMetadata>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultOIDCProviderMetadataParsingStrategy.class);

    @Override
    @Nullable
    public List<OIDCProviderMetadata> apply(@Nullable byte[] rawMetdata) {
        if (rawMetdata == null) {
            this.log.warn("Raw metadata is null, unable to parse OIDC Provider Metadata");
            return CollectionSupport.emptyList();
        }
        try {
            OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)new String(rawMetdata, StandardCharsets.UTF_8));
            if (metadata != null) {
                return List.of(metadata);
            }
            return CollectionSupport.emptyList();
        }
        catch (ParseException e) {
            this.log.error("Error parsing bytes to metadata", (Throwable)e);
            return CollectionSupport.emptyList();
        }
    }
}

