/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultJSONMapParsingStrategy<V>
implements Function<byte[], List<Map<String, V>>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultJSONMapParsingStrategy.class);
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final MapType mapType;

    public DefaultJSONMapParsingStrategy(@Nonnull ObjectMapper mapper, @Nonnull Class<V> valueClass) {
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper can not be null");
        this.mapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, (Class)Constraint.isNotNull(valueClass, (String)"Value class can not be null"));
    }

    public DefaultJSONMapParsingStrategy(@Nonnull Class<V> valueClass) {
        this(new ObjectMapper(), valueClass);
    }

    @Override
    public List<Map<String, V>> apply(@Nullable byte[] rawMetadata) {
        try {
            if (rawMetadata == null) {
                return Collections.emptyList();
            }
            Map parsed = (Map)this.objectMapper.readValue(new String(rawMetadata, StandardCharsets.UTF_8).replace("\\", "\\\\"), (JavaType)this.mapType);
            if (parsed != null) {
                return List.of(parsed);
            }
            return Collections.emptyList();
        }
        catch (JsonProcessingException e) {
            this.log.error("Could not parse input raw metadata to a map", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

