/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.BatchBackingStore;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.cache.impl.AbstractMetadataCache;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.slf4j.Logger;

@ThreadSafe
public class BatchMetadataCache<IdentifierType, MetadataType>
extends AbstractMetadataCache<IdentifierType, MetadataType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BatchMetadataCache.class);
    @NonnullAfterInit
    @Positive
    private Duration maxRefreshDelay;
    @NonnullAfterInit
    @Positive
    private Duration minRefreshDelay;
    @NonnullAfterInit
    private LoadingStrategy loadingStrategy;
    @NonnullAfterInit
    private Function<byte[], List<MetadataType>> parsingStrategy;
    @NonnullAfterInit
    private Function<byte[], Instant> sourceMetadataExpiryStrategy;
    @NonnullAfterInit
    private Predicate<byte[]> sourceMetadataValidPredicate;
    private boolean matchOnIdentifierRequired = true;
    @Nonnull
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    protected BatchMetadataCache(@Nonnull BatchBackingStore<IdentifierType, MetadataType> store) {
        this(store, null);
    }

    protected BatchMetadataCache(@Nonnull BatchBackingStore<IdentifierType, MetadataType> store, @Nullable ScheduledExecutorService executor) {
        super(store, executor);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.maxRefreshDelay == null || this.minRefreshDelay == null) {
            throw new ComponentInitializationException("Refreshable metadata cache not property initialized");
        }
        if (this.sourceMetadataExpiryStrategy == null) {
            throw new ComponentInitializationException("Source metadata expiration time strategy can not be null");
        }
        if (this.loadingStrategy == null) {
            throw new ComponentInitializationException("Loading strategy can not be null");
        }
        if (this.parsingStrategy == null) {
            throw new ComponentInitializationException("Parsing strategy can not be null");
        }
        if (this.sourceMetadataValidPredicate == null) {
            throw new ComponentInitializationException("Is source metadata valid predicate can not be null");
        }
        try {
            this.loadCache();
        }
        catch (MetadataCacheException e) {
            throw new ComponentInitializationException("Error loading metadata during init", (Exception)((Object)e));
        }
    }

    public void setSourceMetadataValidPredicate(@Nonnull Predicate<byte[]> predicate) {
        this.checkSetterPreconditions();
        this.sourceMetadataValidPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Is source metadata valid predicate can not be null");
    }

    @NonnullAfterInit
    protected Predicate<byte[]> getSourceMetadataValidPredicate() {
        return this.sourceMetadataValidPredicate;
    }

    public void setLoadingStrategy(@Nonnull LoadingStrategy strategy) {
        this.checkSetterPreconditions();
        this.loadingStrategy = (LoadingStrategy)Constraint.isNotNull((Object)strategy, (String)"Loading strategy can not be null");
    }

    @NonnullAfterInit
    protected LoadingStrategy getLoadingStrategy() {
        return this.loadingStrategy;
    }

    public void setParsingStrategy(@Nonnull Function<byte[], List<MetadataType>> strategy) {
        this.checkSetterPreconditions();
        this.parsingStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parsing strategy can not be null");
    }

    @NonnullAfterInit
    protected Function<byte[], List<MetadataType>> getParsingStrategy() {
        return this.parsingStrategy;
    }

    public void setSourceMetadataExpiryStrategy(@Nonnull Function<byte[], Instant> strategy) {
        this.checkSetterPreconditions();
        this.sourceMetadataExpiryStrategy = (Function)Constraint.isNotNull(strategy, (String)"Source metadata expiry strategy can not be null");
    }

    @NonnullAfterInit
    protected Function<byte[], Instant> getSourceMetadataExpiryStrategy() {
        return this.sourceMetadataExpiryStrategy;
    }

    public void setMatchOnIdentifierRequired(boolean required) {
        this.checkSetterPreconditions();
        this.matchOnIdentifierRequired = required;
    }

    protected boolean isMatchOnIdentifierRequired() {
        return this.matchOnIdentifierRequired;
    }

    @Override
    @Nonnull
    protected BatchBackingStore<IdentifierType, MetadataType> getBackingStore() {
        return (BatchBackingStore)super.getBackingStore();
    }

    public void setMinRefreshDelay(@Nonnull @Positive Duration delay) {
        this.checkSetterPreconditions();
        Constraint.isFalse((delay == null || delay.isNegative() ? 1 : 0) != 0, (String)"Minimum refresh delay must be greater than 0");
        this.minRefreshDelay = delay;
    }

    @NonnullAfterInit
    protected Duration getMinRefreshDelay() {
        return this.minRefreshDelay;
    }

    public void setMaxRefreshDelay(@Nonnull @Positive Duration delay) {
        this.checkSetterPreconditions();
        Constraint.isFalse((delay == null || delay.isNegative() ? 1 : 0) != 0, (String)"Maximum refresh delay must be greater than 0");
        this.maxRefreshDelay = delay;
    }

    @NonnullAfterInit
    protected Duration getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<MetadataType> get(@Nonnull CriteriaSet criteria) throws MetadataCacheException {
        if (!this.isInitialized()) {
            throw new MetadataCacheException("Metadata cache has not been initialized");
        }
        this.readWriteLock.readLock().lock();
        try {
            Object identifier = this.getCriteriaToIdentifierStrategy().apply(criteria);
            this.log.debug("{} Resolved criteria to identifier: {}", (Object)this.getLogPrefix(), identifier);
            if (identifier != null) {
                List allMetadata = this.lookupIdentifier(identifier);
                if (allMetadata.isEmpty()) {
                    this.log.debug("{} No metadata candidates for '{}' found, returning empty result", (Object)this.getLogPrefix(), identifier);
                    List list = CollectionSupport.emptyList();
                    return list;
                }
                this.log.debug("{} There are {} metadata candidates for '{}' found in cache", new Object[]{this.getLogPrefix(), allMetadata.size(), identifier});
                List list = allMetadata;
                return list;
            }
            if (!this.matchOnIdentifierRequired) {
                this.log.debug("{} No identifier found to lookup, identifier match is not required, returning all known metadata", (Object)this.getLogPrefix());
                List list = CollectionSupport.copyToList((Collection)this.getBackingStore().getOrderedValues());
                return list;
            }
            this.log.debug("{} No identifier found to lookup, returning empty result", (Object)this.getLogPrefix());
            List list = CollectionSupport.emptyList();
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private CacheLoadingContext createLoadingContext() {
        return new CacheLoadingContext(this.getBackingStore().getLastUpdate(), this.getBackingStore().getLastRefresh());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws MetadataCacheException {
        this.readWriteLock.writeLock().lock();
        try {
            this.log.debug("{} Populating metadata cache for '{}'", (Object)this.getLogPrefix(), (Object)this.loadingStrategy.getSourceIdentifier());
            Instant now = Instant.now();
            Instant metadataExpiration = null;
            try {
                if (this.isDestroyed()) {
                    return;
                }
                byte[] rawFetchedMetadata = this.loadingStrategy.load(this.createLoadingContext());
                if (rawFetchedMetadata != null) {
                    if (this.sourceMetadataValidPredicate.test(rawFetchedMetadata)) {
                        List<MetadataType> parsedMetadata = this.parsingStrategy.apply(rawFetchedMetadata);
                        if (parsedMetadata != null && !parsedMetadata.isEmpty()) {
                            this.log.info("{} Parsed {} metadata candidates, loading into cache", (Object)this.getLogPrefix(), (Object)parsedMetadata.size());
                            this.freshLoad(parsedMetadata);
                            this.getBackingStore().setOriginalValue(rawFetchedMetadata);
                            this.getBackingStore().setLastUpdate(now);
                        }
                        metadataExpiration = this.sourceMetadataExpiryStrategy.apply(this.getBackingStore().getOriginalValue());
                    } else {
                        this.log.warn("{} Source metadata is not valid, nothing to load", (Object)this.getLogPrefix());
                    }
                } else {
                    this.log.info("{} Metadata has not changed since last refresh", (Object)this.getLogPrefix());
                }
            }
            catch (Throwable t) {
                this.log.error("{} Error loading or parsing metadata", (Object)this.getLogPrefix(), (Object)t);
                if (t instanceof Exception) {
                    throw new MetadataCacheException((Exception)t);
                }
                throw new MetadataCacheException(String.format("Saw an error of type '%s' with message '%s'", t.getClass().getName(), t.getMessage()));
            }
            finally {
                if (metadataExpiration == null || metadataExpiration.isBefore(now)) {
                    this.scheduleNextRefresh(null);
                } else {
                    Duration nextRefreshDelay = this.computeNextRefreshDelay(metadataExpiration);
                    this.scheduleNextRefresh(nextRefreshDelay);
                }
                this.getBackingStore().setLastRefresh(now);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void scheduleNextRefresh(@Nullable Duration delay) {
        Duration refreshDelay = delay;
        if (delay == null || delay.isZero()) {
            refreshDelay = this.maxRefreshDelay;
        }
        Instant nextRefresh = Instant.now().plus(refreshDelay);
        long nextRefreshDelay = nextRefresh.toEpochMilli() - System.currentTimeMillis();
        this.getExecutorService().schedule(this.errorHandlingWrapper(new AsynchronousRefreshAHeadTask()), nextRefreshDelay, TimeUnit.MILLISECONDS);
        this.log.info("{} Next refresh cycle for metadata provider '{}' will occur on '{}' ('{}' local time)", new Object[]{this.getLogPrefix(), this.loadingStrategy.getSourceIdentifier(), nextRefresh, nextRefresh.atZone(ZoneId.systemDefault())});
    }

    @Nonnull
    private Duration computeNextRefreshDelay(Instant expectedExpiration) {
        long refreshDelay;
        long now = System.currentTimeMillis();
        long expireInstant = 0L;
        if (expectedExpiration != null) {
            expireInstant = expectedExpiration.toEpochMilli();
        }
        if ((refreshDelay = (long)((float)(expireInstant - now) * this.getRefreshDelayFactor().floatValue())) < this.minRefreshDelay.toMillis()) {
            refreshDelay = this.minRefreshDelay.toMillis();
        }
        return Duration.ofMillis(refreshDelay);
    }

    private class AsynchronousRefreshAHeadTask
    implements Runnable {
        private AsynchronousRefreshAHeadTask() {
        }

        @Override
        public void run() {
            if (!BatchMetadataCache.this.isInitialized()) {
                return;
            }
            try {
                BatchMetadataCache.this.loadCache();
            }
            catch (MetadataCacheException e) {
                BatchMetadataCache.this.log.warn("{} Failed to background re-load cache for '{}'", new Object[]{BatchMetadataCache.this.getLogPrefix(), BatchMetadataCache.this.loadingStrategy.getSourceIdentifier(), e});
                return;
            }
        }
    }
}

