/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.saml.xmlobject.impl;

import javax.annotation.Nonnull;
import net.shibboleth.oidc.saml.xmlobject.OAuthRPExtensions;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.w3c.dom.Element;

public class OAuthRPExtensionsMarshaller
extends AbstractSAMLObjectMarshaller {
    protected void marshallAttributes(@Nonnull XMLObject samlElement, @Nonnull Element domElement) throws MarshallingException {
        OAuthRPExtensions rpExtensions = (OAuthRPExtensions)samlElement;
        if (rpExtensions.getTokenEndpointAuthMethod() != null) {
            domElement.setAttributeNS(null, "token_endpoint_auth_method", rpExtensions.getTokenEndpointAuthMethod());
        }
        if (rpExtensions.getGrantTypes() != null) {
            domElement.setAttributeNS(null, "grant_types", rpExtensions.getGrantTypes());
        }
        if (rpExtensions.getResponseTypes() != null) {
            domElement.setAttributeNS(null, "response_types", rpExtensions.getResponseTypes());
        }
        if (rpExtensions.getApplicationType() != null) {
            domElement.setAttributeNS(null, "application_type", rpExtensions.getApplicationType());
        }
        if (rpExtensions.getClientUri() != null) {
            domElement.setAttributeNS(null, "client_uri", rpExtensions.getClientUri());
        }
        if (rpExtensions.getScopes() != null) {
            domElement.setAttributeNS(null, "scopes", rpExtensions.getScopes());
        }
        if (rpExtensions.getSoftwareId() != null) {
            domElement.setAttributeNS(null, "software_id", rpExtensions.getSoftwareId());
        }
        if (rpExtensions.getSoftwareVersion() != null) {
            domElement.setAttributeNS(null, "software_version", rpExtensions.getSoftwareVersion());
        }
        if (rpExtensions.getSectorIdentifierUri() != null) {
            domElement.setAttributeNS(null, "sector_identifier_uri", rpExtensions.getSectorIdentifierUri());
        }
        if (rpExtensions.getIdTokenSignedResponseAlg() != null) {
            domElement.setAttributeNS(null, "id_token_signed_response_alg", rpExtensions.getIdTokenSignedResponseAlg());
        }
        if (rpExtensions.getIdTokenEncryptedResponseAlg() != null) {
            domElement.setAttributeNS(null, "id_token_encrypted_response_alg", rpExtensions.getIdTokenEncryptedResponseAlg());
        }
        if (rpExtensions.getIdTokenEncryptedResponseEnc() != null) {
            domElement.setAttributeNS(null, "id_token_encrypted_response_enc", rpExtensions.getIdTokenEncryptedResponseEnc());
        }
        if (rpExtensions.getUserInfoSignedResponseAlg() != null) {
            domElement.setAttributeNS(null, "userinfo_signed_response_alg", rpExtensions.getUserInfoSignedResponseAlg());
        }
        if (rpExtensions.getUserInfoEncryptedResponseAlg() != null) {
            domElement.setAttributeNS(null, "userinfo_encrypted_response_alg", rpExtensions.getUserInfoEncryptedResponseAlg());
        }
        if (rpExtensions.getUserInfoEncryptedResponseEnc() != null) {
            domElement.setAttributeNS(null, "userinfo_encrypted_response_enc", rpExtensions.getUserInfoEncryptedResponseEnc());
        }
        if (rpExtensions.getRequestObjectSigningAlg() != null) {
            domElement.setAttributeNS(null, "request_object_signing_alg", rpExtensions.getRequestObjectSigningAlg());
        }
        if (rpExtensions.getRequestObjectEncryptionAlg() != null) {
            domElement.setAttributeNS(null, "request_object_encryption_alg", rpExtensions.getRequestObjectEncryptionAlg());
        }
        if (rpExtensions.getRequestObjectEncryptionEnc() != null) {
            domElement.setAttributeNS(null, "request_object_encryption_enc", rpExtensions.getRequestObjectEncryptionEnc());
        }
        if (rpExtensions.getTokenEndpointAuthSigningAlg() != null) {
            domElement.setAttributeNS(null, "token_endpoint_auth_signing_alg", rpExtensions.getTokenEndpointAuthSigningAlg());
        }
        if (rpExtensions.getInitiateLoginUri() != null) {
            domElement.setAttributeNS(null, "initiate_login_uri", rpExtensions.getInitiateLoginUri());
        }
        if (rpExtensions.getDefaultMaxAge() != 0) {
            domElement.setAttributeNS(null, "default_max_age", Integer.toString(rpExtensions.getDefaultMaxAge()));
        }
        if (rpExtensions.isRequireAuthTime()) {
            domElement.setAttributeNS(null, "require_auth_time", Boolean.toString(rpExtensions.isRequireAuthTime()));
        }
        if (rpExtensions.isBackChannelLogoutSessionRequired()) {
            domElement.setAttributeNS(null, "backchannel_logout_session_required", Boolean.toString(rpExtensions.isBackChannelLogoutSessionRequired()));
        }
        if (rpExtensions.isFrontChannelLogoutSessionRequired()) {
            domElement.setAttributeNS(null, "frontchannel_logout_session_required", Boolean.toString(rpExtensions.isFrontChannelLogoutSessionRequired()));
        }
        this.marshallUnknownAttributes((AttributeExtensibleXMLObject)rpExtensions, domElement);
    }
}

