/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config.impl;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenRevocationConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2TokenValidatingConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOAuth2TokenRevocationConfiguration
extends AbstractOAuth2TokenValidatingConfiguration
implements OAuth2TokenRevocationConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oauth2.revocation";
    @Nonnull
    private Function<ProfileRequestContext, String> revocationMethodLookupStrategy = FunctionSupport.constant((Object)OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN.toString());
    @Nonnull
    private Function<ProfileRequestContext, Duration> revocationLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(6L));

    public DefaultOAuth2TokenRevocationConfiguration() {
        this("http://shibboleth.net/ns/profiles/oauth2/revocation");
    }

    public DefaultOAuth2TokenRevocationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public void setRevocationMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.revocationMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRevocationMethod(@Nullable OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod method) {
        this.revocationMethodLookupStrategy = FunctionSupport.constant((Object)(method != null ? method.toString() : null));
    }

    public OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod getRevocationMethod(@Nullable ProfileRequestContext profileRequestContext) {
        String method = this.revocationMethodLookupStrategy.apply(profileRequestContext);
        if (method != null) {
            try {
                return OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.valueOf((String)method);
            }
            catch (IllegalArgumentException e) {
                throw new ConstraintViolationException("Unexpected revocation method value: '" + method + "': " + e.getMessage());
            }
        }
        return null;
    }

    public void setRevocationLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.revocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getRevocationLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.revocationLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Revocation lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setRevocationLifetime(@Nonnull @Positive Duration lifetime) {
        Duration revocationLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Revocation lifetime cannot be null");
        Constraint.isTrue((!revocationLifetime.isZero() && !revocationLifetime.isNegative() ? 1 : 0) != 0, (String)"Revocation lifetime must be greater than 0");
        this.revocationLifetimeLookupStrategy = FunctionSupport.constant((Object)revocationLifetime);
    }
}

