/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoding.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoding.impl.AbstractOIDCMessageEncoder;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2AuthorizationProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.slf4j.Logger;

public class HTTPPostAuthnRequestEncoder
extends AbstractOIDCMessageEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/oidc-request-form-post.vm";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPPostAuthnRequestEncoder.class);
    @Nullable
    private VelocityEngine velocityEngine;
    @Nonnull
    @NotEmpty
    private String velocityTemplateId = "/templates/oidc-request-form-post.vm";
    @Nullable
    private StringDigester cspDigester;
    @Nullable
    private IdentifierGenerationStrategy cspNonceGenerator;

    public void setCSPDigester(@Nullable StringDigester digester) {
        this.checkSetterPreconditions();
        this.cspDigester = digester;
    }

    public void setCSPNonceGenerator(@Nullable IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.cspNonceGenerator = strategy;
    }

    public void setVelocityTemplateId(@Nonnull @NotEmpty String newVelocityTemplateId) {
        this.checkSetterPreconditions();
        this.velocityTemplateId = Constraint.isNotEmpty((String)newVelocityTemplateId, (String)"Velocity template id must not not be null or empty");
    }

    public void setVelocityEngine(@Nonnull VelocityEngine newVelocityEngine) {
        this.checkSetterPreconditions();
        this.velocityEngine = (VelocityEngine)Constraint.isNotNull((Object)newVelocityEngine, (String)"Velocity engine can not be null");
    }

    public boolean test(@Nullable OAuth2AuthorizationProfileConfiguration.HttpRequestMethod requestMethod) {
        return OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.POST.equals((Object)requestMethod);
    }

    private VelocityContext doPostEncode(@Nonnull OIDCAuthenticationRequest request, @Nonnull HttpServletResponse httpResponse) throws MessageEncodingException {
        VelocityContext context = new VelocityContext();
        List<Pair<String, String>> params = this.createParametersFromRequest(request);
        params.forEach(param -> context.put((String)param.getFirst(), (Object)HTMLEncoder.encodeForHTML((String)((String)param.getSecond()))));
        URI endpoint = request.getEndpointURI();
        if (endpoint == null) {
            throw new MessageEncodingException("Endpoint URI for form action is null.");
        }
        context.put("response", (Object)httpResponse);
        if (this.cspDigester != null) {
            context.put("cspDigester", (Object)this.cspDigester);
        }
        if (this.cspNonceGenerator != null) {
            context.put("cspNonce", (Object)this.cspNonceGenerator);
        }
        context.put("action", (Object)HTMLEncoder.encodeForHTMLAttribute((String)endpoint.toString()));
        this.log.trace("Velocity context OIDC parameters: {}", params);
        return context;
    }

    protected void doEncode() throws MessageEncodingException {
        if (this.velocityEngine == null) {
            throw new MessageEncodingException("VelocityEngine must be supplied for form post request mode.");
        }
        this.log.debug("Encoding OIDC authentication request using HTTP Form Post Serialization");
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (!(outboundMessage instanceof OIDCAuthenticationRequest)) {
            throw new MessageEncodingException("No outbound OIDC authentication request message contained in message context.");
        }
        HttpServletResponse response = this.getHttpServletResponse();
        if (response == null) {
            throw new MessageEncodingException("No HttpServletResponse available.");
        }
        try {
            HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
            HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
            HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/html");
            VelocityContext context = this.doPostEncode((OIDCAuthenticationRequest)outboundMessage, response);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);){
                assert (this.velocityEngine != null);
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            this.log.error("Error creating authorization POST request: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error creating authorization POST request.", e);
        }
    }
}

