/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.impl;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.oidc.profile.config.OIDCLogoutProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2InterceptorAwareProfileConfiguration;
import net.shibboleth.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDCLogoutConfiguration
extends AbstractOAuth2InterceptorAwareProfileConfiguration
implements OIDCLogoutProfileConfiguration,
OverriddenIssuerProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidc.logout";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> preferFrontChannelPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> frontChannelSuccessPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> revokeTokensPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> requireIdTokenHintPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, BiPredicate<String, SPSession>> logoutHintMatchingStrategyLookupStrategy = FunctionSupport.constant((str, session) -> false);

    public DefaultOIDCLogoutConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidc/logout");
    }

    public DefaultOIDCLogoutConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    public boolean isPreferFrontChannel(@Nullable ProfileRequestContext profileRequestContext) {
        return this.preferFrontChannelPredicate.test(profileRequestContext);
    }

    public void setPreferFrontChannel(boolean flag) {
        this.preferFrontChannelPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setPreferFrontChannelPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.preferFrontChannelPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Prefer front-channel predicate cannot be null");
    }

    public boolean isFrontChannelSuccess(@Nullable ProfileRequestContext profileRequestContext) {
        return this.frontChannelSuccessPredicate.test(profileRequestContext);
    }

    public void setFrontChannelSuccess(boolean flag) {
        this.frontChannelSuccessPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setFrontChannelSuccessPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.frontChannelSuccessPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Front-channel success predicate cannot be null");
    }

    public boolean isRevokeTokens(@Nullable ProfileRequestContext profileRequestContext) {
        return this.revokeTokensPredicate.test(profileRequestContext);
    }

    public void setRevokeTokens(boolean flag) {
        this.revokeTokensPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setRevokeTokensPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.revokeTokensPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Front-channel success predicate cannot be null");
    }

    public boolean isRequireIdTokenHint(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireIdTokenHintPredicate.test(profileRequestContext);
    }

    public void setRequireIdTokenHint(boolean flag) {
        this.requireIdTokenHintPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setRequireIdTokenHintPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireIdTokenHintPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Require id_token_hint predicate cannot be null");
    }

    @Nullable
    public BiPredicate<String, SPSession> getLogoutHintMatchingStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.logoutHintMatchingStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setLogoutHintMatchingStrategy(@Nonnull BiPredicate<String, SPSession> strategy) {
        Constraint.isNotNull(strategy, (String)"Matching strategy cannot be null");
        this.logoutHintMatchingStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setLogoutHintMatchingStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiPredicate<String, SPSession>> strategy) {
        this.logoutHintMatchingStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Require id_token_hint predicate lookup strategy cannot be null");
    }
}

