/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.audit.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import org.opensaml.profile.context.ProfileRequestContext;

public class ForceAuthnAuditExtractor
implements Function<ProfileRequestContext, Boolean> {
    @Nonnull
    private final Function<ProfileRequestContext, Object> requestLookupStrategy;

    public ForceAuthnAuditExtractor(@Nonnull Function<ProfileRequestContext, Object> strategy) {
        this.requestLookupStrategy = strategy;
    }

    @Override
    @Nullable
    public Boolean apply(@Nullable ProfileRequestContext input) {
        OIDCAuthenticationRequest req;
        Prompt prompt;
        Object requestObject = this.requestLookupStrategy.apply(input);
        if (requestObject == null) {
            return null;
        }
        if (requestObject instanceof OIDCAuthenticationRequest && (prompt = (req = (OIDCAuthenticationRequest)requestObject).getPrompt()) != null) {
            return prompt.contains((Object)Prompt.Type.LOGIN);
        }
        if (requestObject instanceof AuthenticationRequest && (req = (AuthenticationRequest)requestObject).getPrompt() != null) {
            return req.getPrompt().contains((Object)Prompt.Type.LOGIN);
        }
        return false;
    }
}

