/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.audit.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractClaimsSetAuditExtractor<T>
extends AbstractInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractClaimsSetAuditExtractor.class);
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String claimName;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Function<ProfileRequestContext, ClaimsSet> claimsSetLookupStrategy;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.claimName == null) {
            throw new ComponentInitializationException("Claim name can not be null");
        }
        if (this.claimsSetLookupStrategy == null) {
            throw new ComponentInitializationException("jwtLookupStrategy can not be null");
        }
    }

    @NonnullAfterInit
    protected synchronized String getClaimName() {
        return this.claimName;
    }

    public synchronized void setClaimName(@Nonnull String claim) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.claimName = (String)Constraint.isNotNull((Object)claim, (String)"claimName can not be null");
    }

    public synchronized void setClaimsSetLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsSet> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.claimsSetLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"claimsSetLookupStrategy can not be null");
    }

    @NonnullAfterInit
    private synchronized Function<ProfileRequestContext, ClaimsSet> getClaimsSetLookupStrategy() {
        return this.claimsSetLookupStrategy;
    }

    @Nullable
    protected abstract T doLookup(@Nonnull ClaimsSet var1) throws ParseException;

    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        ClaimsSet claims = this.getClaimsSetLookupStrategy().apply(input);
        if (claims != null) {
            try {
                return this.doLookup(claims);
            }
            catch (ParseException e) {
                this.log.debug("Unable to extract claim '{}'", (Object)this.getClaimName(), (Object)e);
                return null;
            }
        }
        return null;
    }
}

