/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential;

import com.google.common.io.ByteStreams;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.spring.credential.AbstractCredentialFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;

public class BasicJWKCredentialFactoryBean
extends AbstractCredentialFactoryBean<BasicJWKCredential> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicJWKCredentialFactoryBean.class);
    @Nullable
    private Resource jwkResource;
    private boolean failIfResourceIsNull = true;
    @Nonnull
    private String symmetricKeyAlgorithm = "AES";

    public void setSymmetricKeyAlgorithm(@Nonnull @NotEmpty String algorithm) {
        this.symmetricKeyAlgorithm = Constraint.isNotEmpty((String)algorithm, (String)"SymmetricKeyAlgorithm cannot be null");
    }

    public void setFailIfResourceIsNull(boolean flag) {
        this.failIfResourceIsNull = flag;
    }

    public void setResource(@Nonnull Resource res) {
        this.jwkResource = res;
    }

    protected BasicJWKCredential doCreateInstance() throws Exception {
        BasicJWKCredential jwkCredential;
        JWK jwk;
        block17: {
            Resource localResource = this.jwkResource;
            if (localResource == null) {
                if (this.failIfResourceIsNull) {
                    this.log.error("{}: No JWK credential provided", (Object)this.getConfigDescription());
                    throw new BeanCreationException("No JWK credential provided");
                }
                return null;
            }
            jwk = null;
            jwkCredential = null;
            try (InputStream is = localResource.getInputStream();){
                jwk = JWK.parse((String)new String(ByteStreams.toByteArray((InputStream)is)));
                jwkCredential = new BasicJWKCredential();
                if ((jwk.getKeyType() == KeyType.EC || jwk.getKeyType() == KeyType.RSA) && jwk instanceof AsymmetricJWK) {
                    PublicKey publicKey;
                    AsymmetricJWK asymmetricJwk = (AsymmetricJWK)jwk;
                    if (jwk.isPrivate()) {
                        PrivateKey privateKey = asymmetricJwk.toPrivateKey();
                        if (privateKey == null) {
                            throw new BeanCreationException("Private Key was null in " + localResource.getDescription());
                        }
                        jwkCredential.setPrivateKey(privateKey);
                    }
                    if ((publicKey = asymmetricJwk.toPublicKey()) == null) {
                        throw new BeanCreationException("Public Key was null in " + localResource.getDescription());
                    }
                    jwkCredential.setPublicKey(publicKey);
                    break block17;
                }
                if (jwk.getKeyType() == KeyType.OCT && jwk instanceof OctetSequenceKey) {
                    OctetSequenceKey octetSequeceKey = (OctetSequenceKey)jwk;
                    SecretKey secretKey = octetSequeceKey.toSecretKey(this.symmetricKeyAlgorithm);
                    if (secretKey == null) {
                        throw new BeanCreationException("Public Key was null in " + localResource.getDescription());
                    }
                    jwkCredential.setSecretKey(secretKey);
                    break block17;
                }
                throw new BeanCreationException("Unsupported KeyFile at " + localResource.getDescription());
            }
            catch (IOException | ParseException e) {
                this.log.error("{}: Could not decode KeyFile at {}: {}", new Object[]{this.getConfigDescription(), localResource.getDescription(), e});
                throw new BeanCreationException("Could not decode provided KeyFile " + localResource.getDescription(), (Throwable)e);
            }
        }
        jwkCredential.setUsageType(CredentialConversionUtil.getUsageType(jwk));
        jwkCredential.setEntityId(this.getEntityID());
        jwkCredential.setAlgorithm(jwk.getAlgorithm());
        jwkCredential.setKid(jwk.getKeyID());
        List keyNames = this.getKeyNames();
        if (keyNames != null) {
            jwkCredential.getKeyNames().addAll(keyNames);
        }
        return jwkCredential;
    }

    public Class<?> getObjectType() {
        return BasicJWKCredential.class;
    }
}

