/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.spring.factory.AbstractComponentAwareFactoryBean;
import org.springframework.beans.factory.BeanCreationException;

public class BasicClientSecretCredentialFactoryBean
extends AbstractComponentAwareFactoryBean<DefaultClientSecretCredential> {
    @Nullable
    private String secret;

    public void setSecret(@Nonnull @NotEmpty String secretIn) {
        this.secret = Constraint.isNotEmpty((String)secretIn, (String)"Secret cannot be null or empty");
    }

    @Nonnull
    protected DefaultClientSecretCredential doCreateInstance() throws Exception {
        String local = this.secret;
        if (local == null) {
            throw new BeanCreationException("Client secret cannot be null");
        }
        return new DefaultClientSecretCredential(local);
    }

    @Nonnull
    public Class<?> getObjectType() {
        return DefaultClientSecretCredential.class;
    }
}

