/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.criterion;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;

public class EncryptionConfigurationCriterion
implements Criterion {
    @Nonnull
    @NonnullElements
    private final List<EncryptionConfiguration> configs;

    public EncryptionConfigurationCriterion(@Nonnull @NonnullElements @NotEmpty List<EncryptionConfiguration> configurations) {
        this.configs = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(configurations, (String)"List of configurations cannot be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    public EncryptionConfigurationCriterion(EncryptionConfiguration ... configurations) {
        this.configs = CollectionSupport.listOf((Object[])((EncryptionConfiguration[])Constraint.isNotNull((Object)configurations, (String)"List of configurations cannot be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    @NotEmpty
    public List<EncryptionConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EncryptionConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EncryptionConfigurationCriterion) {
            return this.configs.equals(((EncryptionConfigurationCriterion)obj).getConfigurations());
        }
        return false;
    }
}

