/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.impl.ECDSA;
import com.nimbusds.jose.jwk.Curve;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class JWACredentialSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(JWACredentialSupport.class);

    private JWACredentialSupport() {
    }

    public static boolean isECKeyType(@Nullable Key key) {
        if (key == null) {
            return false;
        }
        return key instanceof ECKey;
    }

    public static boolean keySupportsCurve(@Nonnull ECKey key, @Nonnull @NotEmpty JWSAlgorithm algorithm) throws JOSEException {
        JWSAlgorithm algCompatibleWithCredentialCurve = ECDSA.resolveAlgorithm((Curve)Curve.forECParameterSpec((ECParameterSpec)key.getParams()));
        return algCompatibleWithCredentialCurve == algorithm;
    }

    public static boolean keySupportsCurve(@Nonnull ECKey key, @Nonnull @NotEmpty String algorithm) throws JOSEException {
        JWSAlgorithm alg = JWSAlgorithm.parse((String)algorithm);
        assert (alg != null);
        return JWACredentialSupport.keySupportsCurve(key, alg);
    }

    public static boolean keyLengthSupportsMACAlgorithm(@Nonnull JWSAlgorithm macAlg, @Nonnull Key key) {
        if (!JWSAlgorithm.Family.HMAC_SHA.contains((Object)macAlg)) {
            return false;
        }
        if (key.getEncoded() == null) {
            return false;
        }
        int keyLength = key.getEncoded().length * 8;
        boolean keyLengthMatch = false;
        if (JWSAlgorithm.HS256.equals((Object)macAlg)) {
            keyLengthMatch = keyLength >= 256;
        } else if (JWSAlgorithm.HS384.equals((Object)macAlg)) {
            keyLengthMatch = keyLength >= 384;
        } else if (JWSAlgorithm.HS512.equals((Object)macAlg)) {
            boolean bl = keyLengthMatch = keyLength >= 512;
        }
        if (!keyLengthMatch) {
            LOG.trace("Key length of {} bits does not match minimum required for algorithm '{}'", (Object)keyLength, (Object)macAlg);
            return false;
        }
        return true;
    }
}

