/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.util.StandardCharset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.oidc.security.credential.BasicExpiringJWKCredential;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.credential.JWKCredentialSupport;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.security.credential.UsageType;

@ThreadSafe
public class DefaultClientSecretCredential
implements ClientSecretCredential {
    @Nonnull
    private static final String DEFAULT_SECRET_KEY_NAME = "client_secret_credential";
    @Nonnull
    private final byte[] clientSecret;
    @Nonnull
    @NotEmpty
    private final String secretKeyName;

    public DefaultClientSecretCredential(@Nonnull String secret) {
        this(secret, DEFAULT_SECRET_KEY_NAME);
    }

    public DefaultClientSecretCredential(@Nonnull String secret, @Nonnull String keyName) {
        Constraint.isNotEmpty((String)secret, (String)"Secret can not be null or empty");
        byte[] bytes = secret.getBytes(StandardCharset.UTF_8);
        assert (bytes != null);
        this.clientSecret = bytes;
        this.secretKeyName = Constraint.isNotEmpty((String)keyName, (String)"Secret keyname can not be null or empty");
    }

    @Override
    @Nonnull
    public String getSecret() {
        return new String(this.clientSecret, StandardCharsets.UTF_8);
    }

    @Override
    @Nonnull
    @NotLive
    public byte[] getSecretAsBytes() {
        return (byte[])this.clientSecret.clone();
    }

    @Override
    @Nonnull
    public JWKCredential toSigningCredential() {
        BasicExpiringJWKCredential jwkCredential = new BasicExpiringJWKCredential();
        jwkCredential.getKeyNames().add(this.secretKeyName);
        jwkCredential.setKid(this.secretKeyName);
        jwkCredential.setSecretKey(new SecretKeySpec(this.getSecretAsBytes(), "NONE"));
        jwkCredential.setUsageType(UsageType.SIGNING);
        return jwkCredential;
    }

    @Override
    @Nonnull
    public JWKCredential toEncryptionCredential(@Nonnull JWEAlgorithm alg, @Nonnull EncryptionMethod enc) throws JOSEException {
        SecretKey key = JWKCredentialSupport.generateSymmetricKey(this.clientSecret, alg, enc);
        BasicExpiringJWKCredential jwkCredential = new BasicExpiringJWKCredential();
        jwkCredential.getKeyNames().add(this.secretKeyName);
        jwkCredential.setKid(this.secretKeyName);
        jwkCredential.setAlgorithm((Algorithm)alg);
        jwkCredential.setUsageType(UsageType.ENCRYPTION);
        jwkCredential.setSecretKey(key);
        return jwkCredential;
    }
}

