/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential;

import com.google.common.base.Enums;
import com.nimbusds.jose.Algorithm;
import java.time.Duration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.JWSAssemblyUtils;
import net.shibboleth.oidc.security.credential.BasicExpiringJWKCredential;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.credential.ExpiringJWKCredential;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.spring.credential.AbstractCredentialFactoryBean;
import org.springframework.beans.factory.BeanCreationException;

public class BasicExpiringJWTSharedSecretCredentialFactoryBean
extends AbstractCredentialFactoryBean<ExpiringJWKCredential> {
    @Nullable
    private String secret;
    @Nullable
    private String jcaAlg;
    @Nullable
    private Algorithm alg;
    @Nonnull
    private Duration credentialExpiresAt;

    public BasicExpiringJWTSharedSecretCredentialFactoryBean() {
        Duration zero = Duration.ZERO;
        assert (zero != null);
        this.credentialExpiresAt = zero;
        this.jcaAlg = "AES";
    }

    public void setCredentialExpiresAt(@Nonnull Duration expiresAt) {
        this.credentialExpiresAt = (Duration)Constraint.isNotNull((Object)expiresAt, (String)"Credential expiry can not be null");
    }

    public void setJcaAlg(@Nullable String javaAlg) {
        if (StringSupport.trimOrNull((String)javaAlg) != null) {
            this.jcaAlg = javaAlg;
        }
    }

    public void setAlg(@Nonnull Algorithm algorithm) {
        this.alg = (Algorithm)Constraint.isNotNull((Object)algorithm, (String)"Algorithm 'alg' can not be null");
    }

    public void setSecret(@Nonnull @NotEmpty String secretIn) {
        this.secret = Constraint.isNotEmpty((String)secretIn, (String)"Secret can not be null or empty");
    }

    @Nonnull
    protected ExpiringJWKCredential doCreateInstance() throws Exception {
        BasicExpiringJWKCredential jwkCredential = new BasicExpiringJWKCredential();
        String localSecret = this.secret;
        String localAlg = this.jcaAlg;
        if (localSecret == null || localAlg == null) {
            throw new BeanCreationException("Secret and algorithm cannot be null");
        }
        jwkCredential.setSecretKey(KeySupport.decodeSecretKey((byte[])JWSAssemblyUtils.getSecretBytes(localSecret), (String)localAlg));
        jwkCredential.setCredentialExpiresAt(this.credentialExpiresAt);
        jwkCredential.setEntityId(this.getEntityID());
        jwkCredential.setAlgorithm(this.alg);
        if (this.getUsageType() != null) {
            UsageType usageType = (UsageType)Enums.getIfPresent(UsageType.class, (String)this.getUsageType()).or((Object)UsageType.UNSPECIFIED);
            assert (usageType != null);
            jwkCredential.setUsageType(usageType);
        } else {
            jwkCredential.setUsageType(UsageType.UNSPECIFIED);
        }
        List keyNames = this.getKeyNames();
        if (keyNames != null) {
            jwkCredential.getKeyNames().addAll(keyNames);
        }
        return jwkCredential;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return BasicJWKCredential.class;
    }
}

