/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.credential.JWKCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;

public final class CredentialConversionUtil {
    private CredentialConversionUtil() {
    }

    @Nullable
    public static String resolveKid(@Nullable Credential credential) {
        if (credential == null) {
            return null;
        }
        Iterator iterator = credential.getKeyNames().iterator();
        if (iterator.hasNext()) {
            String keyName = (String)iterator.next();
            return keyName;
        }
        if (credential instanceof JWKCredential) {
            return ((JWKCredential)credential).getKid();
        }
        return null;
    }

    @Nullable
    public static KeyUse resolveKeyUse(@Nullable Credential credential) {
        if (credential == null || credential.getUsageType() == null) {
            return null;
        }
        if (UsageType.SIGNING.equals((Object)credential.getUsageType())) {
            return KeyUse.SIGNATURE;
        }
        if (UsageType.ENCRYPTION.equals((Object)credential.getUsageType())) {
            return KeyUse.ENCRYPTION;
        }
        return null;
    }

    @Nullable
    public static JWK credentialToKey(@Nullable Credential credential) {
        if (credential == null) {
            return null;
        }
        PublicKey pkey = credential.getPublicKey();
        if (pkey == null) {
            return null;
        }
        String algorithm = pkey.getAlgorithm();
        if ("RSA".equals(algorithm)) {
            return new RSAKey.Builder((RSAPublicKey)pkey).keyUse(CredentialConversionUtil.resolveKeyUse(credential)).keyID(CredentialConversionUtil.resolveKid(credential)).build();
        }
        if ("EC".equals(algorithm)) {
            return new ECKey.Builder(Curve.forECParameterSpec((ECParameterSpec)((ECPublicKey)pkey).getParams()), (ECPublicKey)credential.getPublicKey()).keyUse(CredentialConversionUtil.resolveKeyUse(credential)).keyID(CredentialConversionUtil.resolveKid(credential)).build();
        }
        return null;
    }

    @Nonnull
    public static JWKCredential copySymmetricCredentialWithNewSecret(@Nonnull JWKCredential credential, @Nullable String newKid, @Nonnull SecretKey derivedKey) {
        BasicJWKCredential jwkCredential = new BasicJWKCredential();
        jwkCredential.setAlgorithm(credential.getAlgorithm());
        jwkCredential.setKid(newKid);
        credential.getKeyNames().add(newKid);
        UsageType utype = credential.getUsageType();
        if (utype != null) {
            jwkCredential.setUsageType(utype);
        }
        jwkCredential.setSecretKey(derivedKey);
        jwkCredential.setEntityId(credential.getEntityId());
        return jwkCredential;
    }

    @Nullable
    public static Credential keyToCredential(@Nullable JWK key) throws JOSEException {
        if (key == null) {
            return null;
        }
        if (key instanceof RSAKey || key instanceof ECKey) {
            BasicJWKCredential jwkCredential = new BasicJWKCredential();
            jwkCredential.setAlgorithm(key.getAlgorithm());
            jwkCredential.setKid(key.getKeyID());
            jwkCredential.getKeyNames().add(key.getKeyID());
            jwkCredential.setUsageType(CredentialConversionUtil.getUsageType(key));
            jwkCredential.setPublicKey(((AsymmetricJWK)key).toPublicKey());
            return jwkCredential;
        }
        return null;
    }

    @Nonnull
    public static UsageType getUsageType(@Nonnull JWK jwk) {
        if (KeyUse.ENCRYPTION.equals((Object)jwk.getKeyUse())) {
            return UsageType.ENCRYPTION;
        }
        if (KeyUse.SIGNATURE.equals((Object)jwk.getKeyUse())) {
            return UsageType.SIGNING;
        }
        return UsageType.UNSPECIFIED;
    }
}

