/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.jwa.algorithm.descriptors;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.KeyTransportAlgorithm;

public class KeyTransportRSA15
implements KeyTransportAlgorithm {
    @Nonnull
    @NotEmpty
    public String getKey() {
        return "RSA";
    }

    @Nonnull
    @NotEmpty
    public String getURI() {
        return "RSA1_5";
    }

    @Nonnull
    public AlgorithmDescriptor.AlgorithmType getType() {
        return AlgorithmDescriptor.AlgorithmType.KeyTransport;
    }

    @Nonnull
    @NotEmpty
    public String getJCAAlgorithmID() {
        String result = String.format("%s/%s/%s", this.getKey(), this.getCipherMode(), this.getPadding());
        assert (result != null);
        return result;
    }

    @Nonnull
    @NotEmpty
    public String getCipherMode() {
        return "ECB";
    }

    @Nonnull
    @NotEmpty
    public String getPadding() {
        return "PKCS1Padding";
    }
}

