/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoding;

import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;

public final class AuthenticationContextClassReferenceSupport {
    private AuthenticationContextClassReferenceSupport() {
    }

    public static final void buildACRClaimsRequest(@Nonnull OIDCAuthenticationRequest authnRequest) {
        List<ACR> acrs = authnRequest.getAcrs();
        if (!acrs.isEmpty()) {
            ClaimsSetRequest.Entry acrEntry = new ClaimsSetRequest.Entry("acr").withValues(acrs).withClaimRequirement(ClaimRequirement.ESSENTIAL);
            OIDCClaimsRequest requestedClaims = authnRequest.getRequestedClaims();
            if (requestedClaims != null && requestedClaims.getIDTokenClaimsRequest() != null) {
                ClaimsSetRequest requestedIdTokenClaims = requestedClaims.getIDTokenClaimsRequest();
                if (requestedIdTokenClaims.get("acr") != null) {
                    ClaimsSetRequest.Entry existingAcr = requestedIdTokenClaims.get("acr");
                    ArrayList<ACR> acrValues = new ArrayList<ACR>();
                    if (existingAcr != null) {
                        if (existingAcr.getValuesAsRawList() != null) {
                            existingAcr.getValuesAsRawList().stream().forEach(acr -> {
                                if (acr instanceof ACR) {
                                    acrValues.add((ACR)acr);
                                } else if (acr != null) {
                                    acrValues.add(new ACR(acr.toString()));
                                }
                            });
                        }
                        if (existingAcr.getRawValue() instanceof ACR) {
                            acrValues.add((ACR)existingAcr.getRawValue());
                        } else if (existingAcr.getRawValue() != null) {
                            acrValues.add(new ACR(existingAcr.getValueAsString()));
                        }
                    }
                    acrs.stream().forEach(acrValues::add);
                    ClaimsSetRequest deletedAcr = requestedIdTokenClaims.delete("acr");
                    ClaimsSetRequest addedNewAcr = deletedAcr.add(new ClaimsSetRequest.Entry("acr").withValues(acrValues).withClaimRequirement(ClaimRequirement.ESSENTIAL));
                    authnRequest.setRequestedClaims(requestedClaims.withIDTokenClaimsRequest(addedNewAcr));
                } else {
                    ClaimsSetRequest requestPlusAcr = requestedIdTokenClaims.add(acrEntry);
                    authnRequest.setRequestedClaims(requestedClaims.withIDTokenClaimsRequest(requestPlusAcr));
                }
            } else {
                ClaimsSetRequest idTokenClaimsRequest = new ClaimsSetRequest().add(acrEntry);
                OIDCClaimsRequest requested = new OIDCClaimsRequest().withIDTokenClaimsRequest(idTokenClaimsRequest);
                authnRequest.setRequestedClaims(requested);
            }
        }
    }
}

