/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.time.Duration;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenRevocationConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public class RevocationLifetimeLookupFunction
extends AbstractRelyingPartyLookupFunction<Duration> {
    private boolean activeProfileOnly = true;

    public void setUseActiveProfileOnly(boolean flag) {
        this.activeProfileOnly = flag;
    }

    @Nullable
    public Duration apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            ProfileConfiguration pc;
            if (this.activeProfileOnly) {
                pc = rpc.getProfileConfig();
            } else {
                RelyingPartyConfiguration rpConfig = rpc.getConfiguration();
                ProfileConfiguration profileConfiguration = pc = rpConfig != null ? rpConfig.getProfileConfiguration(input, "http://shibboleth.net/ns/profiles/oauth2/revocation") : null;
            }
            if (pc instanceof OAuth2TokenRevocationConfiguration) {
                OAuth2TokenRevocationConfiguration rev = (OAuth2TokenRevocationConfiguration)pc;
                return rev.getRevocationLifetime(input);
            }
        }
        return null;
    }
}

