/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class MessageContextLookupFunctionAdaptor<ResultType>
implements Function<MessageContext, ResultType> {
    @Nonnull
    @GuardedBy(value="this")
    private Function<MessageContext, ProfileRequestContext> profileRequestContextLookupStrategy;
    @Nonnull
    private final Function<ProfileRequestContext, ResultType> adaptedFunction;

    public MessageContextLookupFunctionAdaptor(@Nonnull Function<ProfileRequestContext, ResultType> function) {
        this.adaptedFunction = (Function)Constraint.isNotNull(function, (String)"Adapted function can not be null");
        this.profileRequestContextLookupStrategy = new RecursiveTypedParentContextLookup(ProfileRequestContext.class);
    }

    public synchronized void setProfileRequestContextLookupStrategy(@Nonnull Function<MessageContext, ProfileRequestContext> strategy) {
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    private synchronized Function<MessageContext, ProfileRequestContext> getProfileRequestContextLookupStrategy() {
        return this.profileRequestContextLookupStrategy;
    }

    @Override
    public ResultType apply(MessageContext messageContext) {
        return this.adaptedFunction.apply(this.getProfileRequestContextLookupStrategy().apply(messageContext));
    }
}

