/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.JSONSecurityConfiguration;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.AbstractDefaultSecurityConfigurationLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;

public class JWTEncryptionConfigurationLookupFunction
extends AbstractDefaultSecurityConfigurationLookupFunction<List<EncryptionConfiguration>> {
    @Nullable
    @Live
    public List<EncryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
        ArrayList<EncryptionConfiguration> configs = new ArrayList<EncryptionConfiguration>();
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            JSONSecurityConfiguration jsc;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(input)) instanceof JSONSecurityConfiguration && (jsc = (JSONSecurityConfiguration)sc).getJwtEncryptionConfiguration() != null) {
                configs.add(jsc.getJwtEncryptionConfiguration());
            }
            if ((defaultConfig = this.getDefaultSecurityConfiguration(rpc.getConfiguration(), input)) instanceof JSONSecurityConfiguration && (jsc = (JSONSecurityConfiguration)defaultConfig).getJwtEncryptionConfiguration() != null) {
                configs.add(jsc.getJwtEncryptionConfiguration());
            }
        }
        return configs;
    }
}

