/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata;

import com.google.common.base.Objects;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ClientInformationResolver;
import net.shibboleth.oidc.metadata.RefreshableClientInformationResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import org.slf4j.Logger;

public class RelyingPartyClientInformationProvider
extends AbstractServiceableComponent<ClientInformationResolver>
implements RefreshableClientInformationResolver,
Comparable<RelyingPartyClientInformationProvider> {
    private static int sortKeyValue;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RelyingPartyClientInformationProvider.class);
    @NonnullAfterInit
    private ClientInformationResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public void setSortKey(int key) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.sortKey = key;
    }

    public void setEmbeddedResolver(@Nonnull ClientInformationResolver theResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (ClientInformationResolver)Constraint.isNotNull((Object)theResolver, (String)"ClientInformationResolver cannot be null");
    }

    @Nonnull
    public ClientInformationResolver getEmbeddedResolver() {
        this.ifNotInitializedThrowUninitializedComponentException();
        assert (this.resolver != null);
        return this.resolver;
    }

    @Nonnull
    public Iterable<OIDCClientInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        return this.resolver.resolve(criteria);
    }

    @Nullable
    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        return (OIDCClientInformation)this.resolver.resolveSingle(criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        String embeddedId = this.resolver.getId();
        if (embeddedId == null) {
            throw new ComponentInitializationException("Embedded resolver ID cannot be null");
        }
        this.setId(embeddedId);
        super.doInitialize();
        if (null == this.resolver) {
            throw new ComponentInitializationException("ClientInformationResolver cannot be null");
        }
        if (null == this.sortKey) {
            RelyingPartyClientInformationProvider relyingPartyClientInformationProvider = this;
            synchronized (relyingPartyClientInformationProvider) {
                this.sortKey = ++sortKeyValue;
            }
            this.log.info("Top level ClientInformation Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
        }
    }

    @Nonnull
    public ClientInformationResolver getComponent() {
        return this;
    }

    @Override
    public void refresh() throws ResolverException {
        if (this.resolver instanceof RefreshableClientInformationResolver) {
            ((RefreshableClientInformationResolver)this.resolver).refresh();
        }
    }

    @Override
    public Instant getLastRefresh() {
        if (this.resolver instanceof RefreshableClientInformationResolver) {
            return ((RefreshableClientInformationResolver)this.resolver).getLastRefresh();
        }
        return null;
    }

    @Override
    public Instant getLastUpdate() {
        if (this.resolver instanceof RefreshableClientInformationResolver) {
            return ((RefreshableClientInformationResolver)this.resolver).getLastUpdate();
        }
        return null;
    }

    @Override
    public int compareTo(RelyingPartyClientInformationProvider other) {
        this.ifNotInitializedThrowUninitializedComponentException();
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        String id = this.getId();
        assert (id != null);
        return id.compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof RelyingPartyClientInformationProvider)) {
            return false;
        }
        RelyingPartyClientInformationProvider otherRp = (RelyingPartyClientInformationProvider)other;
        return Objects.equal((Object)otherRp.sortKey, (Object)this.sortKey) && Objects.equal((Object)this.getId(), (Object)otherRp.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }
}

