/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import org.slf4j.Logger;

public class ProviderMetadataProviderContainer
extends AbstractServiceableComponent<ProviderMetadataResolver>
implements Comparable<ProviderMetadataProviderContainer> {
    private static int sortKeyValue;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProviderMetadataProviderContainer.class);
    @NonnullAfterInit
    private ProviderMetadataResolver resolver;
    @NonnullAfterInit
    private Integer sortKey;

    public void setSortKey(int key) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.sortKey = key;
    }

    public void setEmbeddedResolver(@Nonnull ProviderMetadataResolver theResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)theResolver, (String)"ProviderMetadataResolver cannot be null");
    }

    @Nonnull
    public ProviderMetadataResolver getEmbeddedResolver() {
        this.ifNotInitializedThrowUninitializedComponentException();
        assert (this.resolver != null);
        return this.resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInitialize() throws ComponentInitializationException {
        String embeddedId = this.resolver.getId();
        if (embeddedId == null) {
            throw new ComponentInitializationException("Embedded resolver ID cannot be null");
        }
        this.setId(embeddedId);
        super.doInitialize();
        if (null == this.resolver) {
            throw new ComponentInitializationException("ProviderMetadataResolver cannot be null");
        }
        if (null != this.sortKey) return;
        Class<ProviderMetadataProviderContainer> clazz = ProviderMetadataProviderContainer.class;
        synchronized (ProviderMetadataProviderContainer.class) {
            this.setSortKey(++sortKeyValue);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.log.info("Top level ProviderMetadata Provider '{}' did not have a sort key; giving it value '{}'", (Object)this.getId(), (Object)this.sortKey);
            return;
        }
    }

    @Nonnull
    public ProviderMetadataResolver getComponent() {
        return this.getEmbeddedResolver();
    }

    @Override
    public int compareTo(ProviderMetadataProviderContainer other) {
        this.ifNotInitializedThrowUninitializedComponentException();
        int result = this.sortKey.compareTo(other.sortKey);
        if (result != 0) {
            return result;
        }
        if (this.equals(other)) {
            return 0;
        }
        String id = this.getId();
        assert (id != null);
        return id.compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof ProviderMetadataProviderContainer)) {
            return false;
        }
        ProviderMetadataProviderContainer otherRp = (ProviderMetadataProviderContainer)other;
        return Objects.equal((Object)otherRp.sortKey, (Object)this.sortKey) && Objects.equal((Object)this.getId(), (Object)otherRp.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortKey, this.getId()});
    }
}

