/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class NumberOfClaimValuesActivationCondition
implements BiPredicate<ProfileRequestContext, JWTClaimsSet> {
    @Nonnull
    @NotEmpty
    private final String claimToCheck;
    @Nonnull
    private final IntPredicate numberOfValuesPredicate;

    public NumberOfClaimValuesActivationCondition(@Nonnull @ParameterName(name="claimToCheck") @NotEmpty String claimName, @Nonnull @ParameterName(name="numberOfValuesPredicate") IntPredicate predicate) {
        this.claimToCheck = Constraint.isNotEmpty((String)claimName, (String)"Claim to check can not be empty or null");
        this.numberOfValuesPredicate = (IntPredicate)Constraint.isNotNull((Object)predicate, (String)"Has Size Predicate can not be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext context, @Nullable JWTClaimsSet claims) {
        if (claims == null || claims.getClaim(this.claimToCheck) == null) {
            return this.numberOfValuesPredicate.test(0);
        }
        Object claimAsObject = claims.getClaim(this.claimToCheck);
        try {
            List claimAsList = (List)claimAsObject;
            return this.numberOfValuesPredicate.test(claimAsList.size());
        }
        catch (ClassCastException e) {
            return this.numberOfValuesPredicate.test(1);
        }
    }
}

