/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;

public class JWTIdentifierRevocationValidator
extends AbstractClaimsValidator {
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @NonnullAfterInit
    @NotEmpty
    private String context;

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        this.checkSetterPreconditions();
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setContext(@Nonnull @NotEmpty String s) {
        this.checkSetterPreconditions();
        this.context = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)s), (String)"Context cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
        if (this.context == null) {
            throw new ComponentInitializationException("Context cannot be null");
        }
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nullable ProfileRequestContext profileRequestContext) throws JWTValidationException {
        String jti = claims.getJWTID();
        if (StringSupport.trimOrNull((String)jti) == null) {
            throw new JWTValidationException("Claims set is missing required JWT identifier claim");
        }
        assert (jti != null && this.context != null);
        if (this.revocationCache.isRevoked(this.context, jti)) {
            throw new JWTValidationException("JWT ID '" + jti + "' has been revoked");
        }
    }
}

