/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public enum JWTClaims {
    JWT_ID_CLAIM("jti"),
    ISSUER_CLAIM("iss"),
    SUBJECT_CLAIM("sub"),
    AUDIENCE_CLAIM("aud"),
    EXPIRATION_TIME_CLAIM("exp"),
    ISSUED_AT_CLAIM("iat"),
    NOT_BEFORE_CLAIM("nbf");

    @Nonnull
    @NotEmpty
    private final String claimName;

    private JWTClaims(String name) {
        this.claimName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Claim name can not be null or empty");
    }

    @Nonnull
    public String getClaimName() {
        return this.claimName;
    }
}

