/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class ExactMatchClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExactMatchClaimsValidator.class);
    @NonnullAfterInit
    private BiFunction<ProfileRequestContext, JWTClaimsSet, String> valueToMatchLookupStrategy;
    @NonnullAfterInit
    @NotEmpty
    private String claimName;

    public void setClaimName(@Nonnull @NotEmpty String name) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.claimName = Constraint.isNotEmpty((String)name, (String)"Claim name can not be null or empty");
    }

    public void setValueToMatchLookupStrategy(@Nonnull BiFunction<ProfileRequestContext, JWTClaimsSet, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.valueToMatchLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Claim value to match lookup strategy can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.claimName == null) {
            throw new ComponentInitializationException("Claim name can not be null");
        }
        if (this.valueToMatchLookupStrategy == null) {
            throw new ComponentInitializationException("Matching value lookup strategy can not be null");
        }
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        Object actualClaim = claims.getClaim(this.claimName);
        if (actualClaim == null) {
            throw new JWTValidationException("Claim '" + this.claimName + "' does not exist");
        }
        String expectedClaim = this.valueToMatchLookupStrategy.apply(context, claims);
        this.log.trace("{}: Checking actual claim '{}' matches expected claim '{}'", new Object[]{this.getId(), actualClaim, expectedClaim});
        if (!actualClaim.equals(expectedClaim)) {
            throw new JWTValidationException("JWT \"" + this.claimName + "\" claim has value " + String.valueOf(actualClaim) + " but should be " + expectedClaim);
        }
    }
}

