/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class ChainingJWTClaimsValidator
extends AbstractIdentifiableInitializableComponent
implements ClaimsValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingJWTClaimsValidator.class);
    @NonnullAfterInit
    @NonnullElements
    private List<ClaimsValidator> claimValidators;
    private boolean requireAll = true;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.claimValidators == null) {
            throw new ComponentInitializationException("List of claims validators can not be null");
        }
    }

    public void setRequireAll(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requireAll = flag;
    }

    public void setClaimValidators(@Nullable @NonnullElements List<ClaimsValidator> validators) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.claimValidators = validators != null ? CollectionSupport.copyToList(validators) : CollectionSupport.emptyList();
    }

    public void validate(@Nullable JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        if (claims == null) {
            this.log.trace("{}: No claims to validation, nothing to do", (Object)this.getId());
            return;
        }
        if (this.claimValidators.isEmpty()) {
            this.log.trace("{}: No validators to check, nothing to do", (Object)this.getId());
            return;
        }
        this.log.debug("{}: Attempting JWT claims validation for subject '{}'", (Object)this.getId(), (Object)claims.getSubject());
        JWTValidationException failure = null;
        for (ClaimsValidator validator : this.claimValidators) {
            this.log.trace("{}: Attempting JWT claims validation '{}'", (Object)this.getId(), (Object)validator.getId());
            try {
                validator.validate(claims, context);
                if (this.requireAll) continue;
                this.log.debug("{}: JWT claims validation for subject '{}' succeeded", (Object)this.getId(), (Object)claims.getSubject());
                return;
            }
            catch (JWTValidationException e) {
                if (this.requireAll) {
                    throw e;
                }
                failure = e;
            }
        }
        if (!this.requireAll) {
            this.log.debug("{}: JWT claims validation for subject '{}' failed, all validators failed", (Object)this.getId(), (Object)claims.getSubject());
            throw failure != null ? failure : new JWTValidationException("Unspecified validation failure");
        }
        this.log.debug("{}: JWT claims validation for subject '{}' succeeded", (Object)this.getId(), (Object)claims.getSubject());
    }
}

