/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.jose.DecryptionConfiguration;
import net.shibboleth.oidc.security.jose.DecryptionParameters;
import net.shibboleth.oidc.security.jose.DecryptionParametersResolver;
import net.shibboleth.oidc.security.jose.criterion.DecryptionConfigurationCriterion;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.xmlsec.AlgorithmPolicyParameters;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.slf4j.Logger;

public class DefaultDecryptionParametersResolver
extends AbstractSecurityParametersResolver<DecryptionParameters>
implements DecryptionParametersResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultDecryptionParametersResolver.class);

    @Nonnull
    public Iterable<DecryptionParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        DecryptionParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList((Object)params);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public DecryptionParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        DecryptionConfigurationCriterion configCrit;
        DecryptionConfigurationCriterion decryptionConfigurationCriterion = configCrit = criteria != null ? (DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class) : null;
        if (configCrit == null) {
            throw new ResolverException("Resolver requires an instance of DecryptionConfigurationCriterion");
        }
        assert (criteria != null);
        DecryptionParameters params = new DecryptionParameters();
        this.resolveAndPopulateIncludesExcludes((AlgorithmPolicyParameters)params, criteria, configCrit.getConfigurations());
        params.setContentEncryptionKeyCredentialResolver(this.resolveContentEncryptionKeyCredentialResolver(criteria));
        params.setKEKCredentialResolver(this.resolveKEKCredentialResolver(criteria));
        criteria.forEach(c -> params.getAdditionalCriteria().add(c));
        this.logResult(params);
        return params;
    }

    @Nullable
    protected JOSEObjectCredentialResolver resolveKEKCredentialResolver(@Nonnull CriteriaSet criteria) {
        DecryptionConfigurationCriterion configCrit = (DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class);
        assert (configCrit != null);
        for (DecryptionConfiguration config : configCrit.getConfigurations()) {
            if (config.getKEKCredentialResolver() == null) continue;
            return config.getKEKCredentialResolver();
        }
        return null;
    }

    @Nullable
    protected JOSEObjectCredentialResolver resolveContentEncryptionKeyCredentialResolver(@Nonnull CriteriaSet criteria) {
        DecryptionConfigurationCriterion configCrit = (DecryptionConfigurationCriterion)criteria.get(DecryptionConfigurationCriterion.class);
        assert (configCrit != null);
        for (DecryptionConfiguration config : configCrit.getConfigurations()) {
            if (config.getContentEncryptionKeyCredentialResolver() == null) continue;
            return config.getContentEncryptionKeyCredentialResolver();
        }
        return null;
    }

    protected void logResult(@Nonnull DecryptionParameters params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved DecryptionParameters:");
            this.log.debug("\tAlgorithm includes: {}", (Object)params.getIncludedAlgorithms());
            this.log.debug("\tAlgorithm excludes: {}", (Object)params.getExcludedAlgorithms());
            this.log.debug("\tContent Encryption Key CredentialResolver: {}", (Object)(params.getContentEncryptionKeyCredentialResolver() != null ? "present" : "null"));
            this.log.debug("\tKEK CredentialResolver: {}", (Object)(params.getKEKCredentialResolver() != null ? "present" : "null"));
        }
    }
}

