/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.impl.AbstractEncryptionAlgorithmsLookupStrategy;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.oidc.security.jose.criterion.EncryptionConfigurationCriterion;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;

public class DefaultDataEncryptionAlgorithmsLookupStrategy
extends AbstractEncryptionAlgorithmsLookupStrategy {
    protected DefaultDataEncryptionAlgorithmsLookupStrategy(@Nullable AlgorithmRegistry registry) {
        super(registry);
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable CriteriaSet criteria, @Nullable Predicate<String> includeExcludePredicate) {
        return this.getDataEncryptionAlgorithmsFromConfiguration(criteria, includeExcludePredicate);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    protected List<String> getDataEncryptionAlgorithmsFromConfiguration(@Nullable CriteriaSet criteria, @Nullable Predicate<String> includeExcludePredicate) {
        EncryptionConfigurationCriterion configCrit;
        EncryptionConfigurationCriterion encryptionConfigurationCriterion = configCrit = criteria != null ? (EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class) : null;
        if (configCrit == null) {
            return CollectionSupport.emptyList();
        }
        ArrayList<String> accumulator = new ArrayList<String>();
        for (EncryptionConfiguration config : configCrit.getConfigurations()) {
            config.getDataEncryptionAlgorithms().stream().filter(includeExcludePredicate != null ? PredicateSupport.and(this.getAlgorithmRuntimeSupportedPredicate(), includeExcludePredicate) : this.getAlgorithmRuntimeSupportedPredicate()).forEach(accumulator::add);
        }
        return accumulator;
    }
}

