/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import net.shibboleth.oidc.security.jose.SignatureSigningParametersResolver;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.jose.impl.BasicSignatureSigningParametersResolver;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class ClientInformationSignatureSigningParametersResolver
extends BasicSignatureSigningParametersResolver
implements SignatureSigningParametersResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationSignatureSigningParametersResolver.class);
    @Nonnull
    private final Function<OIDCClientInformation, String> signatureAlgorithmLookupStrategy;
    @Nullable
    private final String defaultAlgorithmValue;

    public ClientInformationSignatureSigningParametersResolver(@Nonnull @ParameterName(name="signatureAlgorithmLookupStrategy") Function<OIDCClientInformation, String> strategy, @Nullable @ParameterName(name="defaultAlgorithmValue") String defaultValue) {
        this.signatureAlgorithmLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The signature algorithm lookup strategy can not be null");
        this.defaultAlgorithmValue = defaultValue;
    }

    @Override
    @Nonnull
    protected List<String> getEffectiveSignatureAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        List<String> accumulator = super.getEffectiveSignatureAlgorithms(criteria, includeExcludePredicate);
        OIDCClientInformation metadata = this.getClientInformation(criteria);
        if (metadata == null) {
            if (StringSupport.trimOrNull((String)this.defaultAlgorithmValue) != null) {
                this.log.debug("No client information found from the criteria set, using default");
                assert (this.defaultAlgorithmValue != null);
                return this.convertIntoListIfEnabled(this.defaultAlgorithmValue, accumulator);
            }
            this.log.error("No client information found from the criteria set");
            return CollectionSupport.emptyList();
        }
        String algorithm = this.signatureAlgorithmLookupStrategy.apply(metadata);
        if (StringSupport.trimOrNull((String)algorithm) == null) {
            if (StringSupport.trimOrNull((String)this.defaultAlgorithmValue) != null) {
                this.log.debug("No signature algorithm specified in the metadata, using default");
                assert (this.defaultAlgorithmValue != null);
                return this.convertIntoListIfEnabled(this.defaultAlgorithmValue, accumulator);
            }
            this.log.error("No signature algorith or default value specified, returning empty list");
            return CollectionSupport.emptyList();
        }
        assert (algorithm != null);
        return this.convertIntoListIfEnabled(algorithm, accumulator);
    }

    @Nullable
    protected OIDCClientInformation getClientInformation(@Nonnull CriteriaSet criteria) {
        ClientInformationCriterion clientCrit = (ClientInformationCriterion)criteria.get(ClientInformationCriterion.class);
        if (clientCrit != null) {
            return clientCrit.getOidcClientInformation();
        }
        return null;
    }

    @Override
    @Nonnull
    protected List<Credential> getEffectiveSigningCredentials(@Nonnull CriteriaSet criteria) {
        List<Credential> accumulator = super.getEffectiveSigningCredentials(criteria);
        OIDCClientInformation metadata = this.getClientInformation(criteria);
        if (metadata == null) {
            this.log.debug("No client information found from the criteria set");
            return accumulator;
        }
        Secret secret = metadata.getSecret();
        if (secret == null) {
            this.log.debug("No client information secret found from the criteria set");
            return accumulator;
        }
        String secretValue = secret.getValue();
        if (secretValue == null) {
            this.log.debug("No client information secret found from the criteria set");
            return accumulator;
        }
        DefaultClientSecretCredential secretCredential = new DefaultClientSecretCredential(secretValue);
        accumulator.add((Credential)secretCredential.toSigningCredential());
        return accumulator;
    }

    @Nonnull
    protected List<String> convertIntoListIfEnabled(@Nonnull String algorithm, @Nonnull List<String> enabledAlgorithms) {
        if (enabledAlgorithms.contains(algorithm)) {
            return CollectionSupport.listOf((Object)algorithm);
        }
        this.log.warn("The algorithm {} is not enabled, returning empty list", (Object)algorithm);
        return CollectionSupport.emptyList();
    }
}

