/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.jose.impl.DefaultKeyTransportEncryptionAlgorithmsLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.slf4j.Logger;

public class ClientInformationKeyTransportEncryptionAlgorithmsLookupStrategy
extends DefaultKeyTransportEncryptionAlgorithmsLookupStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationKeyTransportEncryptionAlgorithmsLookupStrategy.class);
    @Nonnull
    private final Function<OIDCClientInformation, String> clientKeyTransportAlgorithmLookupStrategy;

    public ClientInformationKeyTransportEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="clientKeyTransportAlgorithmsLookupStrategy") Function<OIDCClientInformation, String> strategy, @Nullable @ParameterName(name="AlgorithmRegistry") AlgorithmRegistry registry) {
        super(registry);
        this.clientKeyTransportAlgorithmLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The client key transport lookup strategy can not be null");
    }

    public ClientInformationKeyTransportEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="clientKeyTransportAlgorithmLookupStrategy") Function<OIDCClientInformation, String> strategy) {
        this(strategy, null);
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable CriteriaSet criteria, @Nullable Predicate<String> includeExcludePredicate) {
        OIDCClientInformation metadata;
        ClientInformationCriterion clientCrit = criteria != null ? (ClientInformationCriterion)criteria.get(ClientInformationCriterion.class) : null;
        OIDCClientInformation oIDCClientInformation = metadata = clientCrit != null ? clientCrit.getOidcClientInformation() : null;
        if (metadata == null) {
            this.log.debug("No client metadata, falling back to default local behaviour");
            return super.apply(criteria, includeExcludePredicate);
        }
        String keyTransportAlgorithm = this.clientKeyTransportAlgorithmLookupStrategy.apply(metadata);
        this.log.trace("Resolved effective key transport algorithm from client metadata: {}", (Object)keyTransportAlgorithm);
        if (keyTransportAlgorithm == null) {
            this.log.debug("Client metadata does not contain 'alg' algorithm value, returning empty list");
            return Collections.emptyList();
        }
        List<String> keyTransportAlgorithmSupported = this.getKeyTransportAlgorithmsFromConfiguration(criteria, includeExcludePredicate);
        this.log.trace("Resolved supported key transport algorithms from config: {}", keyTransportAlgorithmSupported);
        if (keyTransportAlgorithmSupported.contains(keyTransportAlgorithm)) {
            this.log.debug("The algorithm configured in the metadata is supported");
            return List.of(keyTransportAlgorithm);
        }
        this.log.warn("No supported key transport algorithm. Client metadata and configuration are not compatible");
        return CollectionSupport.emptyList();
    }
}

