/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.impl.BasicAlgorithmPolicyConfiguration;

public class BasicSignatureSigningConfiguration
extends BasicAlgorithmPolicyConfiguration
implements SignatureSigningConfiguration {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<Credential> signingCredentials = CollectionSupport.emptyList();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<String> signatureAlgorithms = CollectionSupport.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getSigningCredentials() {
        return this.signingCredentials;
    }

    public void setSigningCredentials(@Nullable @NonnullElements List<Credential> credentials) {
        this.signingCredentials = credentials == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList(credentials);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(@Nullable @NonnullElements List<String> algorithms) {
        this.signatureAlgorithms = algorithms == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(algorithms));
    }
}

