/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.SignedJWT;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.impl.BaseSignedJWTTrustEngine;
import net.shibboleth.oidc.security.impl.ExplicitKeySignedJWTTrustEngine;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class TokenAsymmetricKeyTrustEngine
extends BaseSignedJWTTrustEngine<Credential> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExplicitKeySignedJWTTrustEngine.class);

    protected TokenAsymmetricKeyTrustEngine(@Nonnull @ParameterName(name="JOSEObjectResolver") JOSEObjectCredentialResolver joseObjectResolver) {
        super(joseObjectResolver);
    }

    @Override
    protected boolean doValidate(@Nonnull SignedJWT signedJWT, @Nonnull CriteriaSet trustBasisCriteria) throws SecurityException {
        JWK jwk = signedJWT.getHeader().getJWK();
        if (jwk != null) {
            try {
                if (!(jwk instanceof AsymmetricJWK)) {
                    this.log.warn("JWK in JWT is not asymmetric");
                    return false;
                }
                return this.validate(signedJWT, CredentialConversionUtil.keyToCredential((JWK)jwk));
            }
            catch (JOSEException | SecurityException e) {
                this.log.warn("Could not convert the incoming JWK into credential", e);
            }
        } else {
            this.log.warn("No JWK found from the incoming JWT");
        }
        return false;
    }

    @Override
    protected boolean evaluateTrust(@Nonnull Credential untrustedCredential, @Nullable Credential trustBasis) throws SecurityException {
        PublicKey publicKey = untrustedCredential.getPublicKey();
        if (publicKey != null && trustBasis != null) {
            return publicKey.equals(trustBasis.getPublicKey());
        }
        return false;
    }
}

