/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.impl.ExplicitKeySignedJWTTrustEngine;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.trust.TrustedCredentialTrustEngine;
import org.slf4j.Logger;

public class ClientInformationJWTTrustEngine
extends ExplicitKeySignedJWTTrustEngine
implements TrustedCredentialTrustEngine<SignedJWT> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationJWTTrustEngine.class);
    @Nonnull
    private final Function<OIDCClientInformation, String> signatureAlgorithmLookupStrategy;
    @Nullable
    private final String defaultAlgorithmValue;

    public ClientInformationJWTTrustEngine(@Nonnull @ParameterName(name="resolver") CredentialResolver resolver, @Nonnull @ParameterName(name="JOSEObjectResolver") JOSEObjectCredentialResolver joseObjectResolver, @Nonnull @ParameterName(name="signatureAlgorithmLookupStrategy") Function<OIDCClientInformation, String> strategy, @Nullable @ParameterName(name="defaultAlgorithmValue") String defaultValue) {
        super(resolver, joseObjectResolver);
        this.signatureAlgorithmLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Signature algorithm lookup cannot be null");
        this.defaultAlgorithmValue = StringSupport.trimOrNull((String)defaultValue);
    }

    @Override
    protected boolean doValidate(@Nonnull SignedJWT signedJWT, @Nonnull CriteriaSet trustBasisCriteria) throws SecurityException {
        if (super.doValidate(signedJWT, trustBasisCriteria)) {
            String expectedAlgorithm;
            String tokenAlgorithm = signedJWT.getHeader().getAlgorithm().getName();
            ClientInformationCriterion clientInfo = (ClientInformationCriterion)trustBasisCriteria.get(ClientInformationCriterion.class);
            if (clientInfo != null) {
                expectedAlgorithm = this.getExpectedAlgorithm(clientInfo);
            } else {
                this.log.debug("No client information given, using default value {}", (Object)this.defaultAlgorithmValue);
                expectedAlgorithm = this.defaultAlgorithmValue;
            }
            if (expectedAlgorithm == null) {
                this.log.debug("No expected algorithm defined, accepting {} from the token", (Object)tokenAlgorithm);
                return true;
            }
            if (tokenAlgorithm.equals(expectedAlgorithm)) {
                this.log.debug("The algorithnm specified in the token was expected {}", (Object)tokenAlgorithm);
                return true;
            }
            this.log.warn("The algorithnm specified in the token {} was not expected {}", (Object)tokenAlgorithm, (Object)expectedAlgorithm);
            return false;
        }
        return false;
    }

    @Nullable
    protected String getExpectedAlgorithm(@Nonnull ClientInformationCriterion criterion) {
        OIDCClientInformation metadata = criterion.getOidcClientInformation();
        String storedAlgorithm = this.signatureAlgorithmLookupStrategy.apply(metadata);
        if (StringSupport.trimOrNull((String)storedAlgorithm) == null) {
            this.log.debug("No algorithm value specified in metadata, using default value {}", (Object)this.defaultAlgorithmValue);
            return this.defaultAlgorithmValue;
        }
        this.log.debug("Found the expected algorithm from metadata: {}", (Object)storedAlgorithm);
        return storedAlgorithm;
    }
}

