/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;

public class ReturnAllCollectionJOSEObjectCredentialResolver
implements JOSEObjectCredentialResolver {
    @Nonnull
    private final List<Credential> collection;

    public ReturnAllCollectionJOSEObjectCredentialResolver(@Nonnull @ParameterName(name="credentials") List<Credential> credentials) {
        Constraint.isNotNull(credentials, (String)"Input credentials list cannot be null");
        this.collection = new ArrayList<Credential>(credentials);
    }

    public ReturnAllCollectionJOSEObjectCredentialResolver(@Nonnull @ParameterName(name="credential") Credential credential) {
        Constraint.isNotNull((Object)credential, (String)"Input credential cannot be null");
        this.collection = new ArrayList<Credential>();
        this.collection.add(credential);
    }

    @Nonnull
    public Iterable<Credential> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        return this.collection;
    }

    @Nullable
    public Credential resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterable<Credential> creds = this.resolve(criteria);
        if (creds.iterator().hasNext()) {
            return creds.iterator().next();
        }
        return null;
    }
}

