/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSHeader;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.credential.impl.EvaluableKeyIDCredentialCriterion;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.criteria.PublicKeyCriterion;
import org.slf4j.Logger;

public class LocalJOSEObjectCredentialResolver
extends BasicJOSEObjectCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LocalJOSEObjectCredentialResolver.class);
    @Nonnull
    private final JOSEObjectCredentialResolver localCredResolver;

    public LocalJOSEObjectCredentialResolver(@Nonnull @ParameterName(name="localCredentialResolver") JOSEObjectCredentialResolver localCredentialResolver) {
        this.localCredResolver = (JOSEObjectCredentialResolver)Constraint.isNotNull((Object)localCredentialResolver, (String)"Local credential resolver cannot be null");
    }

    @Nonnull
    public CredentialResolver getLocalCredentialResolver() {
        return this.localCredResolver;
    }

    @Override
    protected void postProcess(@Nullable CriteriaSet criteriaSet, @Nonnull JOSEObject joseObject, @Nonnull List<Credential> credentials) throws ResolverException {
        ArrayList<Credential> results = new ArrayList<Credential>();
        String kid = this.resolveKeyIdFromJoseHeader(joseObject.getHeader());
        for (Credential inputCred : credentials) {
            if (inputCred == null) continue;
            if (this.isLocalCredential(inputCred)) {
                this.log.debug("Input credential was local, including in results");
                results.add(inputCred);
                continue;
            }
            PublicKey pkey = inputCred.getPublicKey();
            if (pkey == null) continue;
            CriteriaSet criteria = new CriteriaSet();
            criteria.add((Object)new PublicKeyCriterion(pkey));
            if (kid != null) {
                this.log.trace("Adding 'kid' value '{}' to credential resolver", (Object)kid);
                criteria.add((Object)new EvaluableKeyIDCredentialCriterion(kid));
            }
            List<Credential> localCredentials = this.resolveLocalCredentialsByCriteria(criteria);
            this.log.trace("Matched {} local credential(s) from {} input credential(s) on 'public key' and optionally 'kid' criterion", (Object)localCredentials.size(), (Object)credentials.size());
            if (localCredentials.isEmpty()) continue;
            results.addAll(localCredentials);
        }
        if (results.isEmpty()) {
            CriteriaSet criteria = new CriteriaSet();
            if (kid != null) {
                this.log.trace("Adding 'kid' value '{}' to credential resolver", (Object)kid);
                criteria.add((Object)new EvaluableKeyIDCredentialCriterion(kid));
            }
            List<Credential> localCredentials = this.resolveLocalCredentialsByCriteria(criteria);
            this.log.trace("Found {} local credential(s)", (Object)localCredentials.size());
            results.addAll(localCredentials);
        }
        credentials.clear();
        credentials.addAll(results);
    }

    @Nonnull
    @NonnullElements
    @Live
    private List<Credential> resolveLocalCredentialsByCriteria(CriteriaSet criteriaSet) throws ResolverException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        for (Credential cred : this.getLocalCredentialResolver().resolve((Object)criteriaSet)) {
            if (cred == null || !this.isLocalCredential(cred)) continue;
            localCreds.add(cred);
        }
        return localCreds;
    }

    @Nullable
    private String resolveKeyIdFromJoseHeader(@Nullable Header header) {
        if (header instanceof JWEHeader) {
            JWEHeader jweHeader = (JWEHeader)header;
            return jweHeader.getKeyID();
        }
        if (header instanceof JWSHeader) {
            JWSHeader jwsHeader = (JWSHeader)header;
            return jwsHeader.getKeyID();
        }
        return null;
    }

    protected boolean isLocalCredential(@Nonnull Credential credential) {
        return credential.getPrivateKey() != null || credential.getSecretKey() != null;
    }
}

