/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import com.nimbusds.jose.JWSAlgorithm;
import java.security.Key;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.oidc.security.credential.JWACredentialSupport;
import net.shibboleth.shared.logic.AbstractTriStatePredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.slf4j.Logger;

public class EvaluableMACKeyLengthCredentialCriterion
extends AbstractTriStatePredicate<Credential>
implements EvaluableCredentialCriterion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableMACKeyLengthCredentialCriterion.class);
    @Nonnull
    private final JWSAlgorithm alg;

    public EvaluableMACKeyLengthCredentialCriterion(@Nonnull JWSAlgorithm algorithm) {
        this.alg = (JWSAlgorithm)Constraint.isNotNull((Object)algorithm, (String)"MAC Algorithm can not be null");
        if (!JWSAlgorithm.Family.HMAC_SHA.contains((Object)algorithm)) {
            throw new ConstraintViolationException("EvaluableMACKeyLengthCredentialCriterion only usable for MAC algorithms");
        }
    }

    public boolean test(@Nullable Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return this.isNullInputSatisfies();
        }
        SecretKey key = target.getSecretKey();
        if (key == null) {
            this.log.error("Credential does not contain a secret key, can not be evaluated for key length");
            return this.isUnevaluableSatisfies();
        }
        return JWACredentialSupport.keyLengthSupportsMACAlgorithm((JWSAlgorithm)this.alg, (Key)key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvaluableMACKeyLengthCredentialCriterion [alg =");
        builder.append(this.alg);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.alg.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EvaluableMACKeyLengthCredentialCriterion) {
            EvaluableMACKeyLengthCredentialCriterion c = (EvaluableMACKeyLengthCredentialCriterion)((Object)obj);
            return this.alg.equals((Object)c.alg);
        }
        return false;
    }
}

