/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.jose.criterion.ClientSecretCredentialCriterion;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class ClientSecretCriterionCredentialResolver
extends BasicJOSEObjectCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientSecretCriterionCredentialResolver.class);

    @Override
    @Nonnull
    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        ClientSecretCredentialCriterion secretCrit;
        if (criteriaSet != null && (secretCrit = (ClientSecretCredentialCriterion)criteriaSet.get(ClientSecretCredentialCriterion.class)) != null) {
            ClientSecretCredential secretCred = secretCrit.getCredential();
            this.log.trace("Found client secret credential");
            Credential derivedCredential = this.deriveClientSecretCredential(secretCred, criteriaSet);
            return derivedCredential != null ? CollectionSupport.listOf((Object)derivedCredential) : CollectionSupport.emptyList();
        }
        this.log.debug("Criteria did not contain a StaticClientSecretCredentialCriterion");
        return CollectionSupport.emptyList();
    }
}

