/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwk.RemoteJwkSetCache;
import net.shibboleth.oidc.security.credential.impl.AbstractClientInformationCredentialResolver;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class ClientInformationCredentialResolver
extends AbstractClientInformationCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationCredentialResolver.class);
    @Nonnull
    private final RemoteJwkSetCache remoteJwkSetCache;
    @Nonnull
    @Positive
    private final Duration keyFetchInterval;

    public ClientInformationCredentialResolver(@Nonnull @ParameterName(name="remoteJwkSetCache") RemoteJwkSetCache jwkSetCache) {
        this(jwkSetCache, Duration.ofMinutes(30L));
    }

    public ClientInformationCredentialResolver(@Nonnull @ParameterName(name="remoteJwkSetCache") RemoteJwkSetCache jwkSetCache, @Nonnull @ParameterName(name="keyFetchInterval") @Positive Duration interval) {
        this.remoteJwkSetCache = (RemoteJwkSetCache)Constraint.isNotNull((Object)jwkSetCache, (String)"The remote JWK set cache cannot be null");
        Constraint.isFalse((interval == null || interval.isNegative() ? 1 : 0) != 0, (String)"Remote key refresh must be greater than 0");
        this.keyFetchInterval = interval;
    }

    @Override
    @Nonnull
    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        ClientInformationCriterion clientCrit;
        Constraint.isNotNull((Object)criteriaSet, (String)"CriteriaSet was null");
        if (criteriaSet != null && (clientCrit = (ClientInformationCriterion)criteriaSet.get(ClientInformationCriterion.class)) != null) {
            return this.resolveFromMetadata(criteriaSet, clientCrit.getOidcClientInformation());
        }
        this.log.debug("Criteria did not contain a ClientInformationCriterion could not perform resolution");
        return CollectionSupport.emptySet();
    }

    @Nonnull
    protected Collection<Credential> resolveFromMetadata(@Nonnull CriteriaSet criteriaSet, @Nonnull OIDCClientInformation information) {
        JWKSet keySet;
        LinkedHashSet<Credential> credentials = new LinkedHashSet<Credential>(1);
        OIDCClientMetadata metadata = information.getOIDCMetadata();
        credentials.addAll(this.resolveSecretCredentials(criteriaSet));
        URI jwkSetURI = metadata.getJWKSetURI();
        if (jwkSetURI != null) {
            String keyIdFromCriteria = this.extractKeyIdFromCriteria(criteriaSet);
            Instant now = Instant.now();
            assert (now != null);
            Instant nowPlusInterval = now.plus(this.keyFetchInterval);
            assert (nowPlusInterval != null);
            if (StringSupport.trimOrNull((String)keyIdFromCriteria) != null) {
                assert (keyIdFromCriteria != null);
                keySet = this.remoteJwkSetCache.fetch(jwkSetURI, keyIdFromCriteria, nowPlusInterval);
            } else {
                keySet = this.remoteJwkSetCache.fetch(jwkSetURI, nowPlusInterval);
            }
            if (keySet == null) {
                this.log.debug("Remote keys could not be fetched, unable to resolve credentials");
                return credentials;
            }
        } else if (metadata.getJWKSet() != null) {
            keySet = metadata.getJWKSet();
        } else {
            return credentials;
        }
        assert (keySet != null);
        this.populateCredentialsFromKeySet(keySet, credentials);
        return credentials;
    }
}

