/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCFlowAwareProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2FlowAwareProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2ClientAuthenticableProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOAuth2FlowAwareProfileConfiguration
extends AbstractOAuth2ClientAuthenticableProfileConfiguration
implements OIDCFlowAwareProfileConfiguration,
OAuth2FlowAwareProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> authorizationCodeFlowPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> implicitFlowPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> hybridFlowPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> refreshTokensPredicate = PredicateSupport.alwaysTrue();

    protected AbstractOAuth2FlowAwareProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isAuthorizationCodeFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authorizationCodeFlowPredicate.test(profileRequestContext);
    }

    public void setAuthorizationCodeFlowEnabled(boolean flag) {
        this.authorizationCodeFlowPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAuthorizationCodeFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.authorizationCodeFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether authorization code flow is supported cannot be null");
    }

    public boolean isHybridFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.hybridFlowPredicate.test(profileRequestContext);
    }

    public void setHybridFlowEnabled(boolean flag) {
        this.hybridFlowPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setHybridFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.hybridFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether implicit flow is supported cannot be null");
    }

    public boolean isImplicitFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.implicitFlowPredicate.test(profileRequestContext);
    }

    public void setImplicitFlowEnabled(boolean flag) {
        this.implicitFlowPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setImplicitFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.implicitFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether hybrid flow is supported cannot be null");
    }

    public boolean isRefreshTokensEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.refreshTokensPredicate.test(profileRequestContext);
    }

    public void setRefreshTokensEnabled(boolean flag) {
        this.refreshTokensPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setRefreshTokensEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.refreshTokensPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether refresh tokens are supported cannot be null");
    }
}

