/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.profile.impl.PopulateJWTSignatureValidationParametersHandler;
import net.shibboleth.oidc.security.jose.SignatureValidationConfiguration;
import net.shibboleth.oidc.security.jose.SignatureValidationParametersResolver;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.action.AbstractHandlerDelegatingProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

public class PopulateJWTSignatureValidationParameters
extends AbstractHandlerDelegatingProfileAction<PopulateJWTSignatureValidationParametersHandler> {
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<SignatureValidationConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private SignatureValidationParametersResolver resolver;

    public PopulateJWTSignatureValidationParameters(@ParameterName(name="strategy") @Nonnull ContextDataLookupFunction<ProfileRequestContext, MessageContext> strategy) {
        super(PopulateJWTSignatureValidationParametersHandler.class, strategy);
        Function spcls = new ChildContextLookup(SecurityParametersContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (spcls != null);
        this.securityParametersContextLookupStrategy = spcls;
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<SignatureValidationConfiguration>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureValidationConfiguration lookup strategy cannot be null");
    }

    public void setSignatureValidationParametersResolver(@Nonnull SignatureValidationParametersResolver newResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (SignatureValidationParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureValidationParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureValidationParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            throw new ComponentInitializationException("ConfigurationLookupStrategy cannot be null");
        }
        PopulateJWTSignatureValidationParametersHandler delegate = (PopulateJWTSignatureValidationParametersHandler)this.getDelegate();
        assert (this.resolver != null);
        delegate.setSignatureValidationParametersResolver(this.resolver);
        assert (this.configurationLookupStrategy != null);
        delegate.setConfigurationLookupStrategy(this.adaptRequired(this.configurationLookupStrategy));
        delegate.setSecurityParametersContextLookupStrategy(this.adaptRequired(this.securityParametersContextLookupStrategy));
        delegate.initialize();
    }
}

