/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.config.logic.EncryptionOptionalPredicate;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableClientProfileConfiguration;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.oidc.security.jose.EncryptionParameters;
import net.shibboleth.oidc.security.jose.EncryptionParametersResolver;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.jose.criterion.ClientSecretCredentialCriterion;
import net.shibboleth.oidc.security.jose.criterion.EncryptionConfigurationCriterion;
import net.shibboleth.oidc.security.jose.criterion.ProviderMetadataCriterion;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.slf4j.Logger;

public class PopulateJWTEncryptionParameters
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateJWTEncryptionParameters.class);
    @Nonnull
    private String forFriendlyName = "not-specified";
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = new EncryptionOptionalPredicate();
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<EncryptionConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private EncryptionParametersResolver encParamsresolver;
    @Nullable
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcClientMetadataContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> oidcProviderMetadataContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    private boolean encryptionOptional;
    private SecurityParametersContext encryptionContext;

    public PopulateJWTEncryptionParameters() {
        Function spcls = new ChildContextLookup(SecurityParametersContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (spcls != null);
        this.securityParametersContextLookupStrategy = spcls;
        this.oidcClientMetadataContextLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class);
        this.oidcProviderMetadataContextLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class);
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setSecurityParametersContextLookupStrategy(Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"securityParametersContextLookupStrategy can not be null");
    }

    public void setClientMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcClientMetadataContextLookupStrategy = strategy;
    }

    public void setProviderMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcProviderMetadataContextLookupStrategy = strategy;
    }

    public void setForFriendlyName(@Nonnull @NotEmpty String name) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.forFriendlyName = Constraint.isNotEmpty((String)name, (String)"ForFriendlyName can not be null or empty");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<EncryptionConfiguration>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionConfiguration lookup strategy cannot be null");
    }

    public void setEncryptionParametersResolver(@Nonnull EncryptionParametersResolver newResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.encParamsresolver = (EncryptionParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"EncryptionParametersResolver cannot be null");
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setEncryptionOptional(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.encryptionOptionalPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.encParamsresolver == null) {
            throw new ComponentInitializationException("EncryptionParametersResolver cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            this.log.debug("{} Encryption disabled for '{}'", (Object)this.getLogPrefix(), (Object)this.forFriendlyName);
            return false;
        }
        this.encryptionContext = this.securityParametersContextLookupStrategy.apply(profileRequestContext);
        if (this.encryptionContext == null) {
            this.log.debug("{} No EncryptionContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.encryptionOptional = this.encryptionOptionalPredicate.test(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving EncryptionParameters for '{}' encryption", (Object)this.getLogPrefix(), (Object)this.forFriendlyName);
        try {
            List<EncryptionConfiguration> encryptionConfigurations = this.configurationLookupStrategy.apply(profileRequestContext);
            if (encryptionConfigurations == null || encryptionConfigurations.isEmpty()) {
                throw new ResolverException("No EncryptionConfigurations returned by lookup strategy");
            }
            CriteriaSet criteria = this.buildCriteriaSet(profileRequestContext, encryptionConfigurations);
            EncryptionParameters params = (EncryptionParameters)this.encParamsresolver.resolveSingle((Object)criteria);
            if (params != null) {
                this.log.debug("{} Resolved EncryptionParameters for {}", (Object)this.getLogPrefix(), (Object)this.forFriendlyName);
                this.encryptionContext.setEncryptionParameters(params);
            } else if (this.encryptionOptional) {
                this.log.debug("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            } else {
                this.log.warn("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            }
        }
        catch (ResolverException e) {
            if (this.encryptionOptional) {
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            }
            this.log.error("{} Error resolving EncryptionParameters", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
        }
    }

    @Nonnull
    private CriteriaSet buildCriteriaSet(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull List<EncryptionConfiguration> encryptionConfigurations) {
        OIDCProviderMetadata metadata;
        OIDCClientInformation info;
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(encryptionConfigurations)});
        criteria.add((Object)new UsageCriterion(UsageType.ENCRYPTION));
        criteria.add((Object)new EncryptionOptionalCriterion(this.encryptionOptional));
        OIDCMetadataContext oidcMetadataCtx = this.oidcClientMetadataContextLookupStrategy != null ? this.oidcClientMetadataContextLookupStrategy.apply(profileRequestContext) : null;
        OIDCClientInformation oIDCClientInformation = info = oidcMetadataCtx != null ? oidcMetadataCtx.getClientInformation() : null;
        if (info != null) {
            this.log.debug("{} Adding OIDC client information to resolution criteria for encryption algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new ClientInformationCriterion(info));
        } else {
            this.log.debug("{} No OIDC client information available", (Object)this.getLogPrefix());
        }
        OIDCProviderMetadataContext oidcProviderMetadataCtx = this.oidcProviderMetadataContextLookupStrategy != null ? this.oidcProviderMetadataContextLookupStrategy.apply(profileRequestContext) : null;
        OIDCProviderMetadata oIDCProviderMetadata = metadata = oidcProviderMetadataCtx != null ? oidcProviderMetadataCtx.getProviderInformation() : null;
        if (metadata != null) {
            this.log.debug("{} Adding OIDC provider information to resolution criteria", (Object)this.getLogPrefix());
            criteria.add((Object)new ProviderMetadataCriterion(metadata));
        } else {
            this.log.debug("{} OIDCProviderMetadataContext is absent", (Object)this.getLogPrefix());
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx != null && rpCtx.getConfiguration() != null && rpCtx.getProfileConfig() instanceof OAuth2ClientAuthenticableClientProfileConfiguration) {
            OAuth2ClientAuthenticableClientProfileConfiguration profileConfiguration = (OAuth2ClientAuthenticableClientProfileConfiguration)rpCtx.getProfileConfig();
            if (profileConfiguration != null) {
                ClientSecretCredential credential = profileConfiguration.getClientCredential(profileRequestContext);
                if (credential != null) {
                    criteria.add((Object)new ClientSecretCredentialCriterion(credential));
                    this.log.debug("{} Adding client_secret credential to resolution criteria", (Object)this.getLogPrefix());
                } else {
                    this.log.trace("{} No client_secret credential found from the profile configuration", (Object)this.getLogPrefix());
                }
            } else {
                this.log.trace("{} Profile configuration not available, shared secret direct encryption credential not present", (Object)this.getLogPrefix());
            }
        }
        return criteria;
    }
}

